/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import java.math.BigDecimal;
import org.apache.cocoon.forms.datatype.validationruleimpl.AbstractValidationRule;
import org.apache.cocoon.forms.formmodel.CannotYetResolveWarning;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.outerj.expression.Expression;
import org.outerj.expression.ExpressionContext;

public class ValueCountValidationRule
extends AbstractValidationRule {
    private Expression exactExpr;
    private Expression minExpr;
    private Expression maxExpr;

    public void setExactExpr(Expression exactExpr) {
        this.exactExpr = exactExpr;
    }

    public void setMinExpr(Expression minExpr) {
        this.minExpr = minExpr;
    }

    public void setMaxExpr(Expression maxExpr) {
        this.maxExpr = maxExpr;
    }

    public ValidationError validate(Object value, ExpressionContext expressionContext) {
        Object[] array = (Object[])value;
        if (this.exactExpr != null) {
            Object result = this.evaluateNumeric(this.exactExpr, expressionContext, "exact", "value-count");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int length = ((BigDecimal)result).intValue();
            if (array.length != length) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.array.exact-valuecount", new String[]{String.valueOf(length)}, "forms"));
            }
            return null;
        }
        if (this.minExpr != null && this.maxExpr != null) {
            Object result = this.evaluateNumeric(this.minExpr, expressionContext, "min", "value-count");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int minLength = ((BigDecimal)result).intValue();
            result = this.evaluateNumeric(this.maxExpr, expressionContext, "max", "value-count");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int maxLength = ((BigDecimal)result).intValue();
            if (array.length < minLength || array.length > maxLength) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.array.range-valuecount", new String[]{String.valueOf(minLength), String.valueOf(maxLength)}, "forms"));
            }
            return null;
        }
        if (this.minExpr != null) {
            Object result = this.evaluateNumeric(this.minExpr, expressionContext, "min", "value-count");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int length = ((BigDecimal)result).intValue();
            if (array.length < length) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.array.min-valuecount", new String[]{String.valueOf(length)}, "forms"));
            }
            return null;
        }
        if (this.maxExpr != null) {
            Object result = this.evaluateNumeric(this.maxExpr, expressionContext, "max", "value-count");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int length = ((BigDecimal)result).intValue();
            if (array.length > length) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.array.max-valuecount", new String[]{String.valueOf(length)}, "forms"));
            }
            return null;
        }
        return null;
    }

    public boolean supportsType(Class clazz, boolean arrayType) {
        return arrayType;
    }
}

