/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.validation.impl;

import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.apache.cocoon.forms.validation.WidgetValidator;
import org.mozilla.javascript.Function;

public class JavaScriptValidator
implements WidgetValidator {
    private final Function function;
    private final Context avalonContext;

    public JavaScriptValidator(Context context, Function function) {
        this.function = function;
        this.avalonContext = context;
    }

    public final boolean validate(Widget widget) {
        Object result;
        Map objectModel = ContextHelper.getObjectModel((Context)this.avalonContext);
        try {
            result = JavaScriptHelper.callFunction(this.function, widget, new Object[]{widget}, objectModel);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error invoking JavaScript event handler", (Throwable)e);
        }
        if (result == null) {
            throw new RuntimeException("Validation script did not return a value");
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new RuntimeException("Validation script returned an unexpected value of type " + result.getClass());
    }
}

