/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.control;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.jcs.config.OptionConverter;
import org.apache.jcs.config.PropertySetter;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class CompositeCacheConfigurator {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$control$CompositeCacheConfigurator == null ? (class$org$apache$jcs$engine$control$CompositeCacheConfigurator = CompositeCacheConfigurator.class$("org.apache.jcs.engine.control.CompositeCacheConfigurator")) : class$org$apache$jcs$engine$control$CompositeCacheConfigurator));
    static final String DEFAULT_REGION = "jcs.default";
    static final String REGION_PREFIX = "jcs.region.";
    static final String SYSTEM_REGION_PREFIX = "jcs.system.";
    static final String AUXILIARY_PREFIX = "jcs.auxiliary.";
    static final String ATTRIBUTE_PREFIX = ".attributes";
    static final String CACHE_ATTRIBUTE_PREFIX = ".cacheattributes";
    static final String ELEMENT_ATTRIBUTE_PREFIX = ".elementattributes";
    private CompositeCacheManager ccMgr;
    static /* synthetic */ Class class$org$apache$jcs$engine$control$CompositeCacheConfigurator;
    static /* synthetic */ Class class$org$apache$jcs$engine$behavior$ICompositeCacheAttributes;
    static /* synthetic */ Class class$org$apache$jcs$engine$behavior$IElementAttributes;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$AuxiliaryCacheFactory;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$AuxiliaryCacheAttributes;

    public CompositeCacheConfigurator(CompositeCacheManager ccMgr) {
        this.ccMgr = ccMgr;
    }

    public void doConfigure(String configFileName) {
        Properties props = new Properties();
        try {
            FileInputStream istream = new FileInputStream(configFileName);
            props.load(istream);
            istream.close();
        }
        catch (IOException e) {
            log.error((Object)("Could not read configuration file, ignored: " + configFileName), (Throwable)e);
            return;
        }
        this.doConfigure(props);
    }

    public void doConfigure(Properties properties) {
        this.ccMgr.props = properties;
        this.setDefaultAuxValues(properties);
        this.setDefaultCompositeCacheAttributes(properties);
        this.setDefaultElementAttributes(properties);
        this.parseSystemRegions(properties);
        this.parseRegions(properties);
    }

    protected void setDefaultAuxValues(Properties props) {
        String value;
        this.ccMgr.defaultAuxValues = value = OptionConverter.findAndSubst(DEFAULT_REGION, props);
        log.info((Object)("setting defaults to " + value));
    }

    protected void setDefaultCompositeCacheAttributes(Properties props) {
        ICompositeCacheAttributes icca = this.parseCompositeCacheAttributes(props, "", DEFAULT_REGION);
        this.ccMgr.setDefaultCacheAttributes(icca);
        log.info((Object)("setting defaultCompositeCacheAttributes to " + icca));
    }

    protected void setDefaultElementAttributes(Properties props) {
        IElementAttributes iea = this.parseElementAttributes(props, "", DEFAULT_REGION);
        this.ccMgr.setDefaultElementAttributes(iea);
        log.info((Object)("setting defaultElementAttributes to " + iea));
    }

    protected void parseSystemRegions(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            CompositeCache cache;
            String key = (String)en.nextElement();
            if (!key.startsWith(SYSTEM_REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(SYSTEM_REGION_PREFIX.length());
            String value = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, regionName, value, null, SYSTEM_REGION_PREFIX);
            }
            this.ccMgr.systemCaches.put(regionName, cache);
            this.ccMgr.caches.put(regionName, cache);
        }
    }

    protected void parseRegions(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            CompositeCache cache;
            String key = (String)en.nextElement();
            if (!key.startsWith(REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(REGION_PREFIX.length());
            String value = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, regionName, value);
            }
            this.ccMgr.caches.put(regionName, cache);
        }
    }

    protected CompositeCache parseRegion(Properties props, String regName, String value) {
        return this.parseRegion(props, regName, value, null, REGION_PREFIX);
    }

    protected CompositeCache parseRegion(Properties props, String regName, String value, ICompositeCacheAttributes cca) {
        return this.parseRegion(props, regName, value, cca, REGION_PREFIX);
    }

    /*
     * Unable to fully structure code
     */
    protected CompositeCache parseRegion(Properties props, String regName, String value, ICompositeCacheAttributes cca, String regionPrefix) {
        if (cca == null) {
            cca = this.parseCompositeCacheAttributes(props, regName, regionPrefix);
        }
        ea = this.parseElementAttributes(props, regName, regionPrefix);
        cache = new CompositeCache(regName, cca, ea);
        auxList = new ArrayList<AuxiliaryCache>();
        CompositeCacheConfigurator.log.debug((Object)("Parsing region name '" + regName + "', value '" + value + "'"));
        st = new StringTokenizer(value, ",");
        if (value.startsWith(",") || value.equals("") || st.hasMoreTokens()) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            auxName = st.nextToken().trim();
            if (auxName == null || auxName.equals(",")) continue;
            CompositeCacheConfigurator.log.debug((Object)("Parsing auxiliary named \"" + auxName + "\"."));
            auxCache = this.parseAuxiliary(cache, props, auxName, regName);
            if (auxCache == null) continue;
            auxList.add(auxCache);
lbl17:
            // 4 sources

            ** while (st.hasMoreTokens())
        }
lbl18:
        // 1 sources

        cache.setAuxCaches(auxList.toArray(new AuxiliaryCache[0]));
        return cache;
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName) {
        return this.parseCompositeCacheAttributes(props, regName, REGION_PREFIX);
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName, String regionPrefix) {
        String attrName = regionPrefix + regName + CACHE_ATTRIBUTE_PREFIX;
        ICompositeCacheAttributes ccAttr = (ICompositeCacheAttributes)OptionConverter.instantiateByKey(props, attrName, class$org$apache$jcs$engine$behavior$ICompositeCacheAttributes == null ? (class$org$apache$jcs$engine$behavior$ICompositeCacheAttributes = CompositeCacheConfigurator.class$("org.apache.jcs.engine.behavior.ICompositeCacheAttributes")) : class$org$apache$jcs$engine$behavior$ICompositeCacheAttributes, null);
        if (ccAttr == null) {
            log.warn((Object)("Could not instantiate ccAttr named '" + attrName + "', using defaults."));
            ICompositeCacheAttributes ccAttr2 = this.ccMgr.getDefaultCacheAttributes();
            ccAttr = ccAttr2.copy();
        }
        log.debug((Object)("Parsing options for '" + attrName + "'"));
        PropertySetter.setProperties(ccAttr, props, attrName + ".");
        ccAttr.setCacheName(regName);
        log.debug((Object)("End of parsing for \"" + attrName + "\"."));
        ccAttr.setCacheName(regName);
        return ccAttr;
    }

    protected IElementAttributes parseElementAttributes(Properties props, String regName, String regionPrefix) {
        String attrName = regionPrefix + regName + ELEMENT_ATTRIBUTE_PREFIX;
        IElementAttributes eAttr = (IElementAttributes)OptionConverter.instantiateByKey(props, attrName, class$org$apache$jcs$engine$behavior$IElementAttributes == null ? (class$org$apache$jcs$engine$behavior$IElementAttributes = CompositeCacheConfigurator.class$("org.apache.jcs.engine.behavior.IElementAttributes")) : class$org$apache$jcs$engine$behavior$IElementAttributes, null);
        if (eAttr == null) {
            log.warn((Object)("Could not instantiate eAttr named '" + attrName + "', using defaults."));
            IElementAttributes eAttr2 = this.ccMgr.getDefaultElementAttributes();
            eAttr = eAttr2.copy();
        }
        log.debug((Object)("Parsing options for '" + attrName + "'"));
        PropertySetter.setProperties(eAttr, props, attrName + ".");
        log.debug((Object)("End of parsing for \"" + attrName + "\"."));
        return eAttr;
    }

    protected AuxiliaryCache parseAuxiliary(CompositeCache cache, Properties props, String auxName, String regName) {
        AuxiliaryCacheFactory auxFac = this.ccMgr.registryFacGet(auxName);
        if (auxFac == null) {
            String prefix = AUXILIARY_PREFIX + auxName;
            auxFac = (AuxiliaryCacheFactory)OptionConverter.instantiateByKey(props, prefix, class$org$apache$jcs$auxiliary$AuxiliaryCacheFactory == null ? (class$org$apache$jcs$auxiliary$AuxiliaryCacheFactory = CompositeCacheConfigurator.class$("org.apache.jcs.auxiliary.AuxiliaryCacheFactory")) : class$org$apache$jcs$auxiliary$AuxiliaryCacheFactory, null);
            if (auxFac == null) {
                log.error((Object)("Could not instantiate auxFactory named \"" + auxName + "\"."));
                return null;
            }
            auxFac.setName(auxName);
            this.ccMgr.registryFacPut(auxFac);
        }
        AuxiliaryCacheAttributes auxAttr = this.ccMgr.registryAttrGet(auxName);
        String attrName = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
        if (auxAttr == null) {
            String prefix = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
            auxAttr = (AuxiliaryCacheAttributes)OptionConverter.instantiateByKey(props, prefix, class$org$apache$jcs$auxiliary$AuxiliaryCacheAttributes == null ? (class$org$apache$jcs$auxiliary$AuxiliaryCacheAttributes = CompositeCacheConfigurator.class$("org.apache.jcs.auxiliary.AuxiliaryCacheAttributes")) : class$org$apache$jcs$auxiliary$AuxiliaryCacheAttributes, null);
            if (auxFac == null) {
                log.error((Object)("Could not instantiate auxAttr named '" + attrName + "'"));
                return null;
            }
            auxAttr.setName(auxName);
            this.ccMgr.registryAttrPut(auxAttr);
        }
        auxAttr = auxAttr.copy();
        log.debug((Object)("Parsing options for '" + attrName + "'"));
        PropertySetter.setProperties(auxAttr, props, attrName + ".");
        auxAttr.setCacheName(regName);
        log.debug((Object)("End of parsing for '" + attrName + "'"));
        auxAttr.setCacheName(regName);
        AuxiliaryCache auxCache = auxFac.createCache(auxAttr, cache);
        return auxCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

