/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;

public class JavaSearchPattern
extends SearchPattern {
    boolean isCaseSensitive;
    int matchMode;

    protected JavaSearchPattern(int patternKind, int matchRule) {
        super(matchRule);
        this.kind = patternKind;
        this.isCaseSensitive = (matchRule & 8) != 0;
        this.matchMode = matchRule - (this.isCaseSensitive ? 8 : 0);
    }

    public SearchPattern getBlankPattern() {
        return null;
    }

    int getMatchMode() {
        return this.matchMode;
    }

    boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this.matchMode) {
                case 0: {
                    return CharOperation.equals(pattern, name, this.isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(pattern, name, this.isCaseSensitive);
                }
                case 2: {
                    if (!this.isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, this.isCaseSensitive);
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }
}

