/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.datasource.JdbcConnectionFactory;
import org.apache.avalon.excalibur.datasource.JdbcConnectionPool;
import org.apache.avalon.excalibur.datasource.NoAvailableConnectionException;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class JdbcDataSource
extends AbstractLogEnabled
implements DataSourceComponent,
Disposable {
    protected JdbcConnectionPool m_pool;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (null == this.m_pool) {
            int l_max;
            int l_min;
            String connectionClass;
            boolean oradb;
            boolean autoCommit;
            long timeout;
            int max;
            int min;
            boolean disableKeepAlive;
            String keepAlive;
            int keepAliveAge;
            String passwd;
            String user;
            String dburl;
            block20: {
                String driver = configuration.getChild("driver").getValue("");
                dburl = configuration.getChild("dburl").getValue();
                user = configuration.getChild("user").getValue(null);
                passwd = configuration.getChild("password").getValue(null);
                Configuration controller = configuration.getChild("pool-controller");
                keepAliveAge = controller.getChild("keep-alive").getAttributeAsInteger("age", 5000);
                keepAlive = controller.getChild("keep-alive").getValue("SELECT 1");
                disableKeepAlive = controller.getChild("keep-alive").getAttributeAsBoolean("disable", false);
                min = controller.getAttributeAsInteger("min", 1);
                max = controller.getAttributeAsInteger("max", 3);
                timeout = controller.getAttributeAsLong("timeout", -1L);
                autoCommit = configuration.getChild("auto-commit").getValueAsBoolean(true);
                oradb = controller.getAttributeAsBoolean("oradb", false);
                connectionClass = controller.getAttribute("connection-class", null);
                if (!"".equals(driver)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Loading new driver: " + driver);
                    }
                    try {
                        Class.forName(driver, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (!this.getLogger().isWarnEnabled()) break block20;
                        this.getLogger().warn("Could not load driver: " + driver, (Throwable)cnfe);
                    }
                }
            }
            if (min < 1) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Minimum number of connections specified must be at least 1.");
                }
                l_min = 1;
            } else {
                l_min = min;
            }
            if (max < 1) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Maximum number of connections specified must be at least 1.");
                }
                l_max = 1;
            } else if (max < min) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Maximum number of connections specified must be more than the minimum number of connections.");
                }
                l_max = min + 1;
            } else {
                l_max = max;
            }
            if (disableKeepAlive) {
                keepAlive = null;
            }
            if (oradb) {
                keepAlive = "SELECT 1 FROM DUAL";
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("The oradb attribute is deprecated, please use thekeep-alive element instead.");
                }
            }
            JdbcConnectionFactory factory = new JdbcConnectionFactory(dburl, user, passwd, autoCommit, keepAlive, keepAliveAge, connectionClass);
            DefaultPoolController poolController = new DefaultPoolController(l_max / 4);
            factory.enableLogging(this.getLogger());
            try {
                this.m_pool = new JdbcConnectionPool(factory, poolController, l_min, l_max, autoCommit);
                this.m_pool.enableLogging(this.getLogger());
                this.m_pool.setTimeout(timeout);
                this.m_pool.initialize();
            }
            catch (Exception e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Error configuring JdbcDataSource", (Throwable)e);
                }
                throw new ConfigurationException("Error configuring JdbcDataSource", (Throwable)e);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.m_pool.get();
        }
        catch (SQLException se) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not return Connection", (Throwable)se);
            }
            throw se;
        }
        catch (Exception e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not return Connection", (Throwable)e);
            }
            throw new NoAvailableConnectionException(e.getMessage());
        }
    }

    public void dispose() {
        this.m_pool.dispose();
        this.m_pool = null;
    }
}

