/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.component.AbstractDualLogEnabled;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class DefaultRoleManager
extends AbstractDualLogEnabled
implements RoleManager,
Configurable {
    private Map m_shorthands;
    private Map m_classNames;
    private Map m_hintClassNames;
    private final RoleManager m_parent;

    public DefaultRoleManager() {
        this.m_parent = null;
    }

    public DefaultRoleManager(RoleManager parent) {
        this.m_parent = parent;
    }

    public final String getRoleForName(String shorthandName) {
        String role = (String)this.m_shorthands.get(shorthandName);
        if (null == role && null != this.m_parent) {
            return this.m_parent.getRoleForName(shorthandName);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("looking up shorthand " + shorthandName + ", returning " + role);
        }
        return role;
    }

    public final String getDefaultClassNameForRole(String role) {
        String className = (String)this.m_classNames.get(role);
        if (null == className && null != this.m_parent) {
            return this.m_parent.getDefaultClassNameForRole(role);
        }
        return className;
    }

    public final String getDefaultClassNameForHint(String role, String shorthand) {
        String s;
        Map hintMap;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("looking up hintmap for role " + role);
        }
        if (null == (hintMap = (Map)this.m_hintClassNames.get(role))) {
            if (null != this.m_parent) {
                return this.m_parent.getDefaultClassNameForHint(role, shorthand);
            }
            return "";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("looking up classname for hint " + shorthand);
        }
        if ((s = (String)hintMap.get(shorthand)) == null && null != this.m_parent) {
            return this.m_parent.getDefaultClassNameForHint(role, shorthand);
        }
        return s;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        HashMap<String, String> shorts = new HashMap<String, String>();
        HashMap<String, String> classes = new HashMap<String, String>();
        HashMap hintclasses = new HashMap();
        Configuration[] roles = configuration.getChildren("role");
        for (int i = 0; i < roles.length; ++i) {
            Configuration[] hints;
            String name = roles[i].getAttribute("name");
            String shorthand = roles[i].getAttribute("shorthand");
            String defaultClassName = roles[i].getAttribute("default-class", null);
            shorts.put(shorthand, name);
            if (null != defaultClassName) {
                classes.put(name, defaultClassName);
            }
            if ((hints = roles[i].getChildren("hint")).length > 0) {
                HashMap<String, String> hintMap = new HashMap<String, String>();
                for (int j = 0; j < hints.length; ++j) {
                    String shortHand = hints[j].getAttribute("shorthand").trim();
                    String className = hints[j].getAttribute("class").trim();
                    hintMap.put(shortHand, className);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Adding hint type " + shortHand + " associated with role " + name + " and class " + className);
                }
                hintclasses.put(name, Collections.unmodifiableMap(hintMap));
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug("added Role " + name + " with shorthand " + shorthand + " for " + defaultClassName);
        }
        this.m_shorthands = Collections.unmodifiableMap(shorts);
        this.m_classNames = Collections.unmodifiableMap(classes);
        this.m_hintClassNames = Collections.unmodifiableMap(hintclasses);
    }
}

