/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfPopulatingCache
extends BlockingCache {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache == null ? (class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache = SelfPopulatingCache.class$("net.sf.ehcache.constructs.blocking.SelfPopulatingCache")) : class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache).getName());
    protected final CacheEntryFactory factory;
    static /* synthetic */ Class class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache;

    public SelfPopulatingCache(Ehcache cache, CacheEntryFactory factory) throws CacheException {
        super(cache);
        this.factory = factory;
    }

    public Element get(Serializable key) throws LockTimeoutException {
        String oldThreadName = Thread.currentThread().getName();
        this.setThreadName("get", key);
        try {
            Object value;
            Element element = super.get(key);
            if (element == null) {
                value = this.factory.createEntry(key);
                this.setThreadName("put", key);
                element = new Element((Object)key, value);
                this.put(element);
            }
            value = element;
            return value;
        }
        catch (Throwable throwable) {
            this.setThreadName("put", key);
            this.put(new Element(key, null));
            try {
                throw new LockTimeoutException("Could not fetch object for cache entry \"" + key + "\".", throwable);
            }
            catch (NoSuchMethodError e) {
                throw new CacheException("Could not fetch object for cache entry \"" + key + "\".");
            }
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    protected void setThreadName(String method, Object key) {
        StringBuffer threadName = new StringBuffer(this.getName()).append(": ").append(method).append("(").append(key).append(")");
        Thread.currentThread().setName(threadName.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws CacheException {
        String oldThreadName = Thread.currentThread().getName();
        Throwable exception = null;
        List keys = this.getKeys();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.getName() + ": found " + keys.size() + " keys to refresh"));
        }
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Serializable key = (Serializable)iterator.next();
            try {
                Ehcache backingCache = this.getCache();
                Element element = backingCache.getQuiet(key);
                if (element == null) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)(this.getName() + ": entry with key " + key + " has been removed - skipping it"));
                    continue;
                }
                this.refreshElement(element, backingCache);
            }
            catch (Exception e) {
                LOG.warn((Object)(this.getName() + "Could not refresh element " + key), (Throwable)e);
                exception = e;
            }
            finally {
                Thread.currentThread().setName(oldThreadName);
            }
        }
        if (exception != null) {
            throw new CacheException(exception.getMessage());
        }
    }

    protected void refreshElement(Element element, Ehcache backingCache) throws Exception {
        Element replacementElement;
        Object key = element.getObjectKey();
        if (LOG.isTraceEnabled()) {
            this.setThreadName("refreshElement", key);
            LOG.trace((Object)(this.getName() + ": refreshing element with key " + key));
        }
        if (this.factory instanceof UpdatingCacheEntryFactory) {
            replacementElement = element;
            ((UpdatingCacheEntryFactory)this.factory).updateEntryValue(key, replacementElement.getValue());
        } else {
            Object value = this.factory.createEntry(key);
            replacementElement = new Element(key, value);
        }
        backingCache.putQuiet(replacementElement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

