/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Properties;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.chaperon.ant.AntLog;
import net.sourceforge.chaperon.model.extended.ExtendedGrammar;
import net.sourceforge.chaperon.process.extended.ExtendedDirectParserProcessor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.IdentityMapper;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class ExtendedParserTask
extends MatchingTask {
    private File srcDir = null;
    private File destDir = null;
    private File baseDir = null;
    private Mapper mapper = null;
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private File grammarFile = null;
    private String parserFactory = null;
    private SAXParserFactory parserFactoryImpl = null;
    private String transformerFactory = null;
    private SAXTransformerFactory transformerFactoryImpl = null;
    private String encoding = "ISO-8859-1";
    private boolean indent = false;
    private boolean flatten = false;
    private String inputtype = "text";
    private int msgLevel = 0;
    private AntLog log;
    private ExtendedGrammar grammar = null;
    private ExtendedDirectParserProcessor parser = null;
    static /* synthetic */ Class class$net$sourceforge$chaperon$model$extended$ExtendedGrammar;

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            this.baseDir = this.project.resolveFile(".");
        }
        if (this.grammarFile == null) {
            throw new BuildException("No grammar file is specified", this.location);
        }
        if (!this.grammarFile.exists()) {
            throw new BuildException("Grammar file doesn't exists:" + this.grammarFile.getAbsolutePath(), this.location);
        }
        if (this.destDir == null) {
            throw new BuildException("No destdir specified!", this.location);
        }
        this.log = new AntLog(this.getProject(), this.msgLevel);
        this.buildAutomata(this.grammarFile);
        DirectoryScanner scanner = this.getDirectoryScanner(this.srcDir);
        Object mapperImpl = this.mapper == null ? new IdentityMapper() : this.mapper.getImplementation();
        String[] list = scanner.getIncludedFiles();
        int i = 0;
        while (i < list.length) {
            String[] dest = mapperImpl.mapFileName(list[i]);
            if (dest != null) {
                int j = 0;
                while (j < dest.length) {
                    this.log("Transforming " + list[i] + " to " + dest[j], 4);
                    this.process(new File(this.srcDir, list[i]), new File(this.destDir, dest[j]));
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setSrcdir(File dir) {
        this.srcDir = dir;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapper = new Mapper(this.project);
        return this.mapper;
    }

    public void setGrammar(File grammarFile) {
        this.grammarFile = grammarFile;
    }

    public void setMsglevel(String msgLevel) {
        if (msgLevel.equalsIgnoreCase("debug")) {
            this.msgLevel = 4;
        } else if (msgLevel.equalsIgnoreCase("verbose")) {
            this.msgLevel = 3;
        } else if (msgLevel.equalsIgnoreCase("info")) {
            this.msgLevel = 2;
        } else if (msgLevel.equalsIgnoreCase("warn")) {
            this.msgLevel = 1;
        } else if (msgLevel.equalsIgnoreCase("error")) {
            this.msgLevel = 0;
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setInputtype(String inputtype) {
        this.inputtype = inputtype;
    }

    public void setParser(String parserFactory) {
        this.parserFactory = parserFactory;
    }

    public void setTransformer(String transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.project);
    }

    private void process(File inFile, File outFile) throws BuildException {
        try {
            if (!inFile.exists()) {
                throw new BuildException("File " + inFile + " doesn't exists", this.location);
            }
            if (inFile.lastModified() > outFile.lastModified() || this.grammarFile.lastModified() > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Parsing file " + inFile + " to " + outFile, 2);
                Properties format = new Properties();
                format.put("encoding", this.encoding);
                if (this.indent) {
                    format.put("indent", "yes");
                }
                format.put("method", "xml");
                SAXTransformerFactory factory = this.getTransformerFactory();
                TransformerHandler serializer = factory.newTransformerHandler();
                serializer.getTransformer().setOutputProperties(format);
                serializer.setResult(new StreamResult(outFile));
                this.parser = new ExtendedDirectParserProcessor();
                this.parser.setLog(this.log);
                this.parser.setFlatten(this.flatten);
                this.parser.setExtendedGrammar(this.grammar);
                this.parser.setContentHandler(serializer);
                if (!this.inputtype.equalsIgnoreCase("xml")) {
                    this.pushTextFile(inFile);
                } else {
                    this.pushXMLFile(inFile);
                }
            }
        }
        catch (Exception ex) {
            if (outFile != null) {
                outFile.delete();
            }
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Failed to process " + inFile + " : " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void buildAutomata(File grammarFile) throws BuildException {
        try {
            this.log("Building grammar from " + grammarFile, 2);
            SAXParserFactory factory = this.getParserFactory();
            factory.setNamespaceAware(true);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            parser.setEntityResolver((EntityResolver)this.xmlCatalog);
            Mapping mapping = new Mapping();
            mapping.loadMapping(new InputSource((class$net$sourceforge$chaperon$model$extended$ExtendedGrammar == null ? (class$net$sourceforge$chaperon$model$extended$ExtendedGrammar = ExtendedParserTask.class$("net.sourceforge.chaperon.model.extended.ExtendedGrammar")) : class$net$sourceforge$chaperon$model$extended$ExtendedGrammar).getResource("mapping.xml").openStream()));
            Unmarshaller unmarshaller = new Unmarshaller(class$net$sourceforge$chaperon$model$extended$ExtendedGrammar == null ? (class$net$sourceforge$chaperon$model$extended$ExtendedGrammar = ExtendedParserTask.class$("net.sourceforge.chaperon.model.extended.ExtendedGrammar")) : class$net$sourceforge$chaperon$model$extended$ExtendedGrammar);
            unmarshaller.setMapping(mapping);
            this.grammar = (ExtendedGrammar)unmarshaller.unmarshal((Reader)new FileReader(grammarFile));
            if (this.log.isDebugEnabled()) {
                this.log.debug("grammar:\n" + this.grammar);
            }
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void pushTextFile(File inFile) throws Exception {
        try {
            String line;
            LocatorImpl locator = new LocatorImpl();
            locator.setSystemId(inFile.toURL().toString());
            locator.setLineNumber(1);
            locator.setColumnNumber(1);
            this.parser.setDocumentLocator(locator);
            this.parser.startDocument();
            this.parser.startElement("http://chaperon.sourceforge.net/schema/text/1.0", "text", "text", new AttributesImpl());
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(inFile)));
            String newline = null;
            String separator = System.getProperty("line.separator");
            while ((line = newline == null ? reader.readLine() : newline) != null) {
                newline = reader.readLine();
                line = newline != null ? line + separator : line;
                locator.setLineNumber(reader.getLineNumber());
                locator.setColumnNumber(1);
                this.parser.characters(line.toCharArray(), 0, line.length());
                if (newline != null) continue;
            }
            reader.close();
            this.parser.endElement("http://chaperon.sourceforge.net/schema/text/1.0", "text", "text");
            this.parser.endDocument();
        }
        catch (SAXParseException se) {
            throw new BuildException("Exception occurs during parsing file " + inFile + " at line " + se.getLineNumber() + " column " + se.getColumnNumber(), (Throwable)se);
        }
    }

    private void pushXMLFile(File inFile) throws Exception {
        SAXParserFactory parserfactory = this.getParserFactory();
        parserfactory.setNamespaceAware(true);
        XMLReader parser = parserfactory.newSAXParser().getXMLReader();
        parser.setEntityResolver((EntityResolver)this.xmlCatalog);
        parser.setContentHandler(this.parser);
        try {
            parser.parse(inFile.toString());
        }
        catch (SAXParseException se) {
            throw new BuildException("Exception occurs during parsing file " + inFile + " at line " + se.getLineNumber() + " column " + se.getColumnNumber(), (Throwable)se);
        }
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = new File(targetFile.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    private SAXParserFactory getParserFactory() throws BuildException {
        if (this.parserFactoryImpl == null) {
            try {
                this.parserFactoryImpl = this.parserFactory == null ? SAXParserFactory.newInstance() : (SAXParserFactory)Class.forName(this.parserFactory).newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Could not load parser factory", (Throwable)e);
            }
        }
        return this.parserFactoryImpl;
    }

    private SAXTransformerFactory getTransformerFactory() throws BuildException {
        if (this.transformerFactoryImpl == null) {
            try {
                this.transformerFactoryImpl = this.transformerFactory == null ? (SAXTransformerFactory)SAXTransformerFactory.newInstance() : (SAXTransformerFactory)Class.forName(this.transformerFactory).newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Could not load transformer factory", (Throwable)e);
            }
        }
        return this.transformerFactoryImpl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

