/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.oai;

import org.apache.excalibur.source.Source;
import org.xml.sax.SAXException;

import java.util.Enumeration;
import java.util.Vector;

public interface OAIRecord extends OAIObject {

	void setOAINamspace(String namespace);

	String getOAINamspace();

	String getIdentifier();

	void setIdentifier(String identifier);

	void identifier() throws SAXException;

	String getDatestamp();

	void setDatestamp(String datestamp);

	void datestamp() throws SAXException;

	void addSetSpec(String setSpec);

	void setSetSpecs(Vector setSpecs);

	Enumeration getSetSpecs();

	void setSpecs() throws SAXException;

	void setMetadataFormat(OAIMetadataFormat format);

	OAIMetadataFormat getMetaDataFormat();

	void setIsDeleted(boolean isDeleted);

	boolean isDeleted();

	void setRecord(Source source);

	Source getRecord();

	void setAbout(Source source);

	Source getAbout();

	void header() throws SAXException;

	void metadata() throws SAXException;

	void about() throws SAXException;

	void record() throws SAXException;

}
