/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.util.apache.cocoon.xml.AbstractSynchronizedXMLPipe;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class SynchronizedOAIObjectImpl extends AbstractSynchronizedXMLPipe implements OAIObject {

    protected Logger logger = null;
    protected DefaultContext _context = null;

    public void enableLogging(Logger logger) {
        this.logger = logger.getChildLogger("oai");
    }

    public void contextualize(Context context) throws ContextException {
        _context = new DefaultContext(context);
    }

    protected DefaultContext getContext() {
        return _context;
    }

    protected void sendElement(String uri, String localName, String qName, Attributes atts, String elemContent) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        this.sendElementContent(elemContent);
        super.endElement(uri, localName, qName);
    }


    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (atts == null) atts = new AttributesImpl();
        super.startElement(uri, localName, qName, atts);

    }

    protected void sendElementContent(String content) throws SAXException {
        if (OAIUtilities.checkString(content)) {
            char[] chars = content.toCharArray();
            super.characters(chars, 0, chars.length);
        }

    }

}
