/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.sitemap.transformers;

import fr.gouv.culture.sdx.pipeline.NodeCountTransformation;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.Transformer;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.util.Map;

public class NodeCounter extends NodeCountTransformation implements Transformer, Parameterizable, Recyclable {
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException,
            SAXException, IOException {
        try {
            if (par.getNames().length > 0)
                this.parameterize(par);
            super.resetFields();//resetting class variables
        } catch (ParameterException e) {
            throw new ProcessingException(e);
        }
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        super.setInternalParameters(parameters);
    }

    /* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.xml.AbstractSdxXMLPipe#initToSax()
	 */
	protected boolean initToSax() {
		if(!super.initToSax())
			return false;
		else{
			this._xmlizable_objects.put("Name",this.getClass().getName());
			this._xmlizable_objects.put("Bounds",this._boundsElem);
			this._xmlizable_objects.put("Count_Mode",this._countMode);
			return true;
		}
	}
}
