/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.rdbms.hsql;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;


public class HSQLDB extends AbstractSdxObject {

    public static final String CLASS_NAME_SUFFIX = "HSQLDB";
    protected final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";
    protected final String PROTOCOL_PREFIX = "jdbc:hsqldb:";

    protected String dbDirPath = null;
    protected Hashtable _registeredTableNames = new Hashtable();
    private Connection conn = null;

    public HSQLDB() throws ClassNotFoundException {
        // Load the HSQL Database Engine JDBC driver
        // hsqldb.jar should be in the class path or made part of the current jar
        Class.forName(HSQLDB_DRIVER);

    }

    public void registerTableName(String tableName) throws SDXException {
        Utilities.isObjectUnique(this._registeredTableNames, tableName, null);
    }

    public void setDbDirPath(String dbDirPath) throws SDXException {
        this.dbDirPath = dbDirPath;
        getSQLConnection();//getting a connection
    }


    public String getDbDirPath() {
        return dbDirPath;
    }

    public synchronized Connection getSQLConnection() throws SDXException {
        // connect to the database.   This will load the db files and start the
        // database if it is not alread running.
        // db_file_name_prefix is used to open or create files that hold the state
        // of the db.
        // It can contain directory names relative to the
        // current working directory
        if (this.conn != null) return this.conn;
        try {
            if (!Utilities.checkString(dbDirPath))
            //TODOException?: better message here
                throw new SQLException("the db directory path for this db instance is not set");
            Connection conn = DriverManager.getConnection(PROTOCOL_PREFIX + dbDirPath, // filenames
                    "sa", // username
                    "");                     // password
            conn.setAutoCommit(true);
            this.conn = conn;
            return conn;
        } catch (SQLException e) {
            String[] args = new String[1];
            args[0] = this.dbDirPath;
            throw new SDXException(super.getLog(), SDXExceptionCode.ERROR_GET_HSQLDB_CONNECTION, args, e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.conn != null)
            this.conn.close();
        //TODO: maybe use a "SHUTDOWN COMPACT" prepared statement here to backup data before the object if finalized
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

	/* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
    	this._xmlizable_objects.put("ID", this.getId());
    	this._xmlizable_objects.put("Encoding", this.getEncoding());
    	this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
		return true;
	}

	/**Init the LinkedHashMap _xmlizable_volatile_objects with the objects in order to describ them in XML
	 * Some objects need to be refresh each time a toSAX is called*/
	protected void initVolatileObjectsToSax() {}


}
