/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.pipeline.Transformation;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.xml.AbstractSdxXMLPipe;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLMulticaster;

public abstract class AbstractPipeline
extends AbstractSdxXMLPipe
implements Pipeline {
    private Parameters params;
    protected LinkedList transformations = new LinkedList();
    protected Vector transformsList = new Vector();
    protected String keepStep = null;
    private ByteArrayOutputStream transformedBytes = null;
    private File transformedFile = null;
    FileOutputStream fOs = null;
    private XMLSerializer xsFile = null;
    private XMLSerializer xsBytes = null;
    private String TEMPFILE_PREFIX = "tempTransDoc";
    private String TEMPFILE_SUFFIX = ".sdx";

    public void configure(Configuration configuration) throws ConfigurationException {
        this.loadBaseConfiguration(configuration);
        super.configure(configuration);
        try {
            this.configureTransformations(configuration);
        }
        catch (SDXException sdxE) {
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
        if (configuration != null) {
            this.params = Parameters.fromConfiguration((Configuration)configuration);
            this.verifyConfigurationParameters(this.params);
        }
    }

    protected void verifyConfigurationParameters(Parameters params) {
        if (params != null) {
            String[] paramNames = params.getNames();
            for (int i = 0; i < paramNames.length; ++i) {
                String paramValue;
                String paramName = paramNames[i];
                if (!Utilities.checkString(paramName) || Utilities.checkString(paramValue = params.getParameter(paramName, null)) && !paramValue.equals("null")) continue;
                params.removeParameter(paramName);
            }
        }
    }

    private void loadBaseConfiguration(Configuration configuration) throws ConfigurationException {
        if (!Utilities.checkString(this.getId()) && configuration != null) {
            try {
                super.setId(configuration.getAttribute("id", new DefaultIDGenerator().generate()));
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    private void configureTransformations(Configuration configuration) throws ConfigurationException, SDXException {
        Configuration[] transforms = null;
        if (configuration != null) {
            transforms = configuration.getChildren(Utilities.getElementName("Transformation"));
        }
        if (transforms != null) {
            for (int i = 0; i < transforms.length; ++i) {
                Transformation trans = null;
                String transType = transforms[i].getAttribute("type");
                ConfigurationUtils.checkConfAttributeValue("type", transType, transforms[i].getLocation());
                Object obj = Utilities.getObjectForClassName(this.getLog(), transType, "fr.gouv.culture.sdx.pipeline.", transType, "Transformation");
                Class<?> l_objClass = obj.getClass();
                if (!(obj instanceof Transformation)) {
                    String[] args = new String[3];
                    args[0] = "Transformation";
                    if (l_objClass != null) {
                        args[1] = l_objClass.getName();
                    }
                    args[2] = transType;
                    throw new SDXException(super.getLog(), 10, args, null);
                }
                trans = (Transformation)obj;
                String transId = (trans = (Transformation)super.setUpSdxObject(trans, transforms[i])).getId();
                if (!Utilities.checkString(transId)) continue;
                if (trans.shouldKeepResult()) {
                    this.keepStep = transId;
                }
                this.transformsList.add(trans);
            }
            for (int k = 0; k < this.transformsList.size(); ++k) {
                Transformation t = (Transformation)this.transformsList.get(k);
                if (t == null) continue;
                this.addTransformation(t);
            }
        }
    }

    public void addTransformation(Transformation t) throws SDXException {
        if (this.transformations.size() > 0) {
            Transformation lastTrans = (Transformation)this.transformations.getLast();
            Transformation consumer = null;
            consumer = lastTrans != null && lastTrans.getId() != null && lastTrans.getId().equals(this.keepStep) ? this.multiCastEvents((XMLConsumer)t) : t;
            lastTrans.recycle();
            lastTrans.setConsumer((XMLConsumer)consumer);
        } else {
            super.recycle();
            this.xmlConsumer = t;
            this.contentHandler = t;
            this.lexicalHandler = t;
        }
        this.transformations.add(t);
    }

    public void setConsumer(XMLConsumer xmlConsumer) {
        try {
            Utilities.checkXmlConsumer(super.getLog(), xmlConsumer);
        }
        catch (SDXException e) {
            // empty catch block
        }
        if (this.transformations.size() > 0) {
            Transformation lastTrans = (Transformation)this.transformations.getLast();
            lastTrans.recycle();
            if (Utilities.checkString(this.keepStep)) {
                if (lastTrans != null && lastTrans.getId() != null && lastTrans.getId().equals(this.keepStep)) {
                    try {
                        xmlConsumer = this.multiCastEvents(xmlConsumer);
                    }
                    catch (SDXException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    this.resetTransformedDocumentFields();
                }
                catch (SDXException sDXException) {
                    // empty catch block
                }
            }
            lastTrans.setConsumer(xmlConsumer);
        } else {
            super.setConsumer(xmlConsumer);
        }
    }

    private void resetTransformedDocumentFields() throws SDXException {
        this.createTempFileResources();
        this.createTempByteResources();
    }

    private XMLConsumer multiCastEvents(XMLConsumer xmlConsumer) throws SDXException {
        XMLMulticaster connector = null;
        try {
            if (this.canBuildTempFile() && this.xsFile == null) {
                this.xsFile = new XMLSerializer();
                this.xsFile.enableLogging(super.getLog());
                this.xsFile.configure((Configuration)new DefaultConfiguration("hack", ""));
            }
            if (this.xsBytes == null) {
                this.xsBytes = new XMLSerializer();
                this.xsBytes.enableLogging(super.getLog());
                this.xsBytes.configure((Configuration)new DefaultConfiguration("hack", ""));
            }
        }
        catch (ConfigurationException e) {
            throw new SDXException(super.getLog(), 0, null, e);
        }
        if (this.xsFile != null) {
            XMLMulticaster serializedOutput = new XMLMulticaster((XMLConsumer)this.xsBytes, (XMLConsumer)this.xsFile);
            connector = new XMLMulticaster((XMLConsumer)serializedOutput, xmlConsumer);
        } else {
            connector = new XMLMulticaster((XMLConsumer)this.xsBytes, xmlConsumer);
        }
        return connector;
    }

    public void setParameters(Parameters params) {
        this.params = params;
        this.setParametersToTransformations(this.params);
    }

    protected void setParametersToTransformations(Parameters parameters) {
        if (this.transformations != null && !this.transformations.isEmpty()) {
            Object[] transforms = this.transformations.toArray();
            for (int i = 0; i < transforms.length; ++i) {
                Transformation t = (Transformation)transforms[i];
                t.setParameters(parameters);
            }
        }
    }

    public Pipeline newInstance() throws SDXException {
        try {
            Pipeline pipe = (Pipeline)this.getClass().newInstance();
            pipe = (Pipeline)super.setUpSdxObject(pipe, super.getConfiguration());
            return pipe;
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{super.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 7001, args, null);
        }
        catch (InstantiationException e) {
            String[] args = new String[]{super.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 7001, args, null);
        }
        catch (IllegalAccessException e) {
            String[] args = new String[]{super.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 7001, args, null);
        }
    }

    public Parameters getParameters() {
        return this.params;
    }

    public byte[] getTransformedBytes() {
        if (this.transformedBytes != null && this.transformedBytes.size() > 0) {
            return this.transformedBytes.toByteArray();
        }
        return null;
    }

    public File getTransformedFile() throws SDXException {
        if (this.fOs != null && this.transformedFile != null && this.transformedFile.exists() && this.transformedFile.length() > 0L) {
            try {
                this.fOs.flush();
            }
            catch (IOException e) {
                throw new SDXException(super.getLog(), 7003, null, e);
            }
            return this.transformedFile;
        }
        return null;
    }

    private void createTempFileResources() throws SDXException {
        try {
            if (this.canBuildTempFile() && this.xsFile != null) {
                File tempDir;
                if (this.fOs != null) {
                    this.fOs.close();
                }
                if (this.transformedFile != null && this.transformedFile.exists() && !this.transformedFile.delete()) {
                    this.transformedFile.deleteOnExit();
                }
                if (!(tempDir = (File)super.getContext().get((Object)"upload-directory")).canWrite()) {
                    tempDir = Utilities.getSystemTempDir();
                }
                tempDir = new File(tempDir, File.separator + "tempTransformedDocs" + File.separator + this.getId() + File.separator);
                tempDir = Utilities.createTempDirectory(this.getLog(), this.getId(), Integer.toString(this.hashCode()), tempDir);
                this.transformedFile = File.createTempFile(this.TEMPFILE_PREFIX, this.TEMPFILE_SUFFIX, tempDir);
                if (this.transformedFile != null && this.transformedFile.exists()) {
                    this.fOs = new FileOutputStream(this.transformedFile);
                }
                if (this.fOs != null) {
                    this.xsFile.recycle();
                    this.xsFile.setOutputStream((OutputStream)this.fOs);
                }
            }
        }
        catch (IOException e) {
            throw new SDXException(super.getLog(), 7002, null, e);
        }
        catch (ContextException e) {
            throw new SDXException(super.getLog(), 7002, null, e);
        }
    }

    private void createTempByteResources() {
        if (this.transformedBytes == null) {
            this.transformedBytes = new ByteArrayOutputStream();
        }
        if (this.transformedBytes != null) {
            this.transformedBytes.reset();
            if (this.xsBytes != null) {
                this.xsBytes.recycle();
                try {
                    this.xsBytes.setOutputStream((OutputStream)this.transformedBytes);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canBuildTempFile() {
        File tempFile = null;
        boolean ret = true;
        try {
            try {
                tempFile = File.createTempFile(this.TEMPFILE_PREFIX, this.TEMPFILE_SUFFIX);
            }
            catch (IOException e) {
                ret = false;
                Object var5_4 = null;
                if (tempFile == null) return ret;
                if (!tempFile.exists()) return ret;
                tempFile.delete();
                return ret;
            }
            Object var5_3 = null;
            if (tempFile == null) return ret;
            if (!tempFile.exists()) return ret;
            tempFile.delete();
            return ret;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tempFile == null) throw throwable;
            if (!tempFile.exists()) throw throwable;
            tempFile.delete();
            throw throwable;
        }
    }

    protected String getClassNameSuffix() {
        return "Pipeline";
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("ID", this.getId());
        this._xmlizable_objects.put("Encoding", this.getEncoding());
        this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
        this._xmlizable_objects.put("Locale", this.getLocale().toString());
        ListIterator iter = this.transformations.listIterator();
        while (iter.hasNext()) {
            Transformation t = (Transformation)iter.next();
            this._xmlizable_objects.put("Transformation", t);
        }
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

