/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.JDBCRepositoryConnection;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.rdbms.DataSourceComponentBacked;
import fr.gouv.culture.sdx.utils.rdbms.JDBC;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLConsumer;

public abstract class AbstractDataSourceComponentBackedRepository
extends DataSourceComponentBacked
implements Repository {
    protected boolean isDefault;
    protected static final String FIELD_ID = "id";
    protected final int PARAM_INDEX_FIELD_ID = 1;

    protected void loadBaseConfiguration(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        try {
            super.setId(configuration.getAttribute(FIELD_ID));
        }
        catch (SDXException e) {
            String[] args = new String[]{configuration.getLocation()};
            SDXException sdxE = new SDXException(super.getLog(), 18, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
        this.isDefault = configuration.getAttributeAsBoolean("default", false);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void delete(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        this.checkConnection(c);
    }

    public void add(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        this.checkConnection(c);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        encoding = this.checkEncoding(encoding);
        this.checkConnection(c);
        return null;
    }

    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkOutputStream(super.getLog(), os);
        this.checkConnection(c);
    }

    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkXmlConsumer(super.getLog(), consumer);
        this.checkConnection(c);
    }

    public void setIsDefault(boolean b) {
        this.isDefault = b;
    }

    protected String checkEncoding(String encoding) throws SDXException {
        String defaultEncoding = "UTF-8";
        if (Utilities.checkString(encoding)) {
            try {
                defaultEncoding.getBytes(encoding);
                return encoding;
            }
            catch (UnsupportedEncodingException e) {
                LoggingUtils.logException(super.getLog(), e);
                try {
                    defaultEncoding.getBytes(defaultEncoding);
                    LoggingUtils.logInfo(super.getLog(), "using the default encoding: " + defaultEncoding);
                    return defaultEncoding;
                }
                catch (UnsupportedEncodingException e1) {
                    String[] args = new String[]{defaultEncoding, e1.getMessage()};
                    throw new SDXException(super.getLog(), 217, args, null);
                }
            }
        }
        return defaultEncoding;
    }

    public void checkConnection(RepositoryConnection c) throws SDXException {
        if (c == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 3005, args, null);
        }
    }

    public void optimize() throws SDXException {
    }

    protected String getDocumentGetQuery() {
        return "SELECT * FROM " + this.getTableName() + " WHERE " + FIELD_ID + " = ?";
    }

    public boolean exists(final String id, RepositoryConnection conn) {
        boolean r_exists = false;
        if (!Utilities.checkString(id)) {
            return r_exists;
        }
        Connection sqlConn = null;
        sqlConn = ((JDBCRepositoryConnection)conn).getConnection();
        String queryString = this.getDocumentGetQuery();
        JDBC.Template template = new JDBC.Template(sqlConn, queryString);
        try {
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                boolean l_exists = false;

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, id);
                }

                public void collect(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        this.l_exists = true;
                    }
                }

                public boolean exists() {
                    return this.l_exists;
                }
            };
            template.execute(qe, 0);
            r_exists = qe.exists();
        }
        catch (SDXException e) {
            String[] args = new String[]{id, this.getId(), e.getMessage()};
            new SDXException(super.getLog(), 3001, args, (Throwable)((Object)e));
        }
        return r_exists;
    }

    protected String getClassNameSuffix() {
        return "Repository";
    }
}

