#!/bin/bash

SEARDUINO_PATH=/opt/searduino

LOG_FILE=$(pwd)/verify-sh.log

FUNC_FILE=$(dirname $0)/functions
if [ ! -f $FUNC_FILE ] || [ "$FUNC_FILE" = "" ]
then
    echo "Can't find the file: 'function'"
    echo "... bailing out"
    exit 1
fi

. $FUNC_FILE

INO_EX=/tmp/ino-example
EX_EX=/tmp/seard-example
EX_PATH=$SEARDUINO_PATH/share/examples/arduino
EXAMPLES_PATH=$SEARDUINO_PATH/share/searduino/example

mkdir -p $EX_EX
mkdir -p $INO_EX
cd       $INO_EX

export ARDUINO_EX_CTR=0
export SEARDUINO_EX_CTR=0

inc_arduino_test()
{
    ARDUINO_EX_CTR=$(( $ARDUINO_EX_CTR + 1 ))
}

inc_searduino_test()
{
    SEARDUINO_EX_CTR=$(( $SEARDUINO_EX_CTR + 1 ))
}


test_report()
{
    echo "Tests performed and passed:"
    echo "   Arduino examples tested:   $ARDUINO_EX_CTR"
    echo "   Searduino examples tested: $SEARDUINO_EX_CTR"
    echo ""
}

test_ex()
{
    TYPE=$1
    EXA=$2

#    echo "Test: type:$TYPE $EXA"
    

    $SEARDUINO_PATH/bin/arduino-ex2c    \
       --searduino-path $SEARDUINO_PATH \
       --$TYPE                          \
       --yes                            \
       $EX_PATH/$EXA
    exit_on_failure_no_print $? "Failed creating C code for $EXA with type $TYPE  (    $SEARDUINO_PATH/bin/arduino-ex2c --searduino-path $SEARDUINO_PATH --$TYPE --yes  $EX_PATH/$EXA
)"

    cd $(basename $EXA)

    make clean 
    exit_on_failure_no_print $? "Make clean in $(pwd)"
    
    make 
    exit_on_failure_no_print $? "Make in $(pwd)"
  
    if [ "$TYPE" = "uno" ] && [ "$UPLOAD" = "true" ] 
    then
	make upload 
	exit_on_failure_no_print $? "Make in $(pwd)"
    fi
  
    if [ "$TYPE" = "shlib" ] && [ "$SIMULATE" = "true" ] 
    then
	make simulate
	exit_on_failure_no_print $? "Make in $(pwd)"
    fi
  
    cd ..
}

test_types()
{
    DIR=$1
    TYPES="shlib prog uno mega due"
    for t in  $TYPES
    do
	test_ex $t $DIR
	exit_on_failure_no_print $?
    done
    inc_arduino_test
    
}


my_log()
{
    log_and_exec_comment "$2" $*
}

test_arduino_examples()
{

    my_log test_types ./1.Basics/AnalogReadSerial
    my_log test_types ./1.Basics/BareMinimum
    my_log test_types ./1.Basics/Blink
    my_log test_types ./1.Basics/DigitalReadSerial
    my_log test_types ./1.Basics/Fade
    my_log test_types ./2.Digital/BlinkWithoutDelay
    my_log test_types ./2.Digital/Button
    my_log test_types ./2.Digital/Debounce
    my_log test_types ./2.Digital/StateChangeDetection
### test_types ./2.Digital/toneKeyboard
### test_types ./2.Digital/toneMelody
### test_types ./2.Digital/toneMultiple
### test_types ./2.Digital/tonePitchFollower
    my_log test_types ./3.Analog/AnalogInOutSerial
    my_log test_types ./3.Analog/AnalogInput
    my_log test_types ./3.Analog/AnalogWriteMega
    my_log test_types ./3.Analog/Calibration
    my_log test_types ./3.Analog/Fading
### test_types ./3.Analog/Smoothing
    my_log test_types ./4.Communication/ASCIITable
    my_log test_types ./4.Communication/Dimmer
    my_log test_types ./4.Communication/Graph
###    test_types ./4.Communication/MIDI
### serial1: ###    test_types ./4.Communication/MultiSerialMega
    my_log test_types ./4.Communication/PhysicalPixel
###    test_types ./4.Communication/SerialCallResponse
###    test_types ./4.Communication/SerialCallResponseASCII
###    test_types ./4.Communication/SerialEvent
    my_log test_types ./4.Communication/VirtualColorMixer
    my_log test_types ./5.Control/Arrays
    my_log test_types ./5.Control/ForLoopIteration
    my_log test_types ./5.Control/IfStatementConditional
    my_log test_types ./5.Control/switchCase
    my_log test_types ./5.Control/switchCase2
###    test_types ./5.Control/WhileStatementConditional
    my_log test_types ./6.Sensors/ADXL3xx
    my_log test_types ./6.Sensors/Knock
###    test_types ./6.Sensors/Memsic2125
###    test_types ./6.Sensors/Ping
    my_log test_types ./7.Display/barGraph
###    test_types ./7.Display/RowColumnScanning
    my_log test_types ./8.Strings/CharacterAnalysis
###    test_types ./8.Strings/StringAdditionOperator
###    test_types ./8.Strings/StringAppendOperator
###    test_types ./8.Strings/StringCaseChanges
###    test_types ./8.Strings/StringCharacters
###    test_types ./8.Strings/StringComparisonOperators
###    test_types ./8.Strings/StringConstructors
###    test_types ./8.Strings/StringIndexOf
###    test_types ./8.Strings/StringLength
###    test_types ./8.Strings/StringLengthTrim
###    test_types ./8.Strings/StringReplace
###    test_types ./8.Strings/StringStartsWithEndsWith
###    test_types ./8.Strings/StringSubstring
###    test_types ./8.Strings/StringToInt
###    test_types ./8.Strings/StringToIntRGB
    echo
}


test_distance()
{
    #
    # DISTANCE 
    log_and_exec_no_print cd verifications/distance

    log_and_exec_no_print make -f Makefile.distance clean all prog

    log_and_exec_no_print ./distance

    inc_searduino_test
    return 0
}

test_digpins()
{
    #
    # DIGPINS
    log_and_exec_no_print cd ../../digpins

    log_and_exec_no_print make -f Makefile.digpins clean all prog
    inc_searduino_test
    return 0
}


test_digcounter()
{
    #
    # DIGCOUNTER
    log_and_exec_no_print  cd ../python-digcounter

    log_and_exec_no_print  make -f Makefile.digcounter clean all 

    inc_searduino_test

    return 0
}


test_examples()
{
    STORED_DIR=$(pwd)

    log_and_exec_no_print cd $EX_EX 

    log_and_exec_no_print cp -r $EXAMPLES_PATH/ .

    log_and_exec_no_print cd $EXAMPLES_PATH/ 

    log_and_exec test_distance
    log_and_exec test_digpins
    log_and_exec test_digcounter


    cd $STORED_DIR
}

while [ "$1" != "" ]
do
    if [ "$1" = "--upload" ]
    then
	export UPLOAD="true"
    elif [ "$1" = "--simulate" ]
    then
	export SIMULATE="true"
    fi
    shift
done


init_logging

#
#
#
test_examples
test_arduino_examples

#
#
#
test_report


