/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log.rollover;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.grlea.log.rollover.RolloverStrategy;

class TimeOfDayRolloverStrategy
implements RolloverStrategy {
    private static final String KEY_ROLLOVER_TIME = "simplelog.rollover.timeOfDay.time";
    private static final String ROLLOVER_TIME_DEFAULT = "0:00";
    private static final String KEY_TIMEZONE = "simplelog.rollover.timeOfDay.timezone";
    private TimeZone timeZone;
    private int hour;
    private int minute;
    private boolean timeSetProgramatically = false;

    TimeOfDayRolloverStrategy() {
        this.timeZone = null;
        this.hour = -1;
        this.minute = -1;
    }

    public TimeOfDayRolloverStrategy(TimeZone timeZone, int n, int n2) {
        this.setRolloverTime(timeZone, n, n2);
    }

    public void configure(Map map) throws IOException {
        TimeZone timeZone;
        Pattern pattern;
        Matcher matcher;
        if (this.timeSetProgramatically) {
            return;
        }
        String string = (String)map.get(KEY_ROLLOVER_TIME);
        if (string == null) {
            string = ROLLOVER_TIME_DEFAULT;
        }
        if ((string = string.trim()).length() == 0) {
            string = ROLLOVER_TIME_DEFAULT;
        }
        if (!(matcher = (pattern = Pattern.compile("([01]?\\d|2[0123]):([0-5]\\d)")).matcher(string)).matches()) {
            throw new IOException("The specified rollover time does not conform to the required pattern: " + string);
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        String string4 = (String)map.get(KEY_TIMEZONE);
        if (string4 != null) {
            timeZone = TimeZone.getTimeZone(string4);
            if (timeZone.getID().equals("GMT") && !string4.equals("GMT")) {
                throw new IOException("A TimeZone with the specified ID could not be created.");
            }
        } else {
            timeZone = TimeZone.getDefault();
        }
        this.setRolloverTimeInternal(timeZone, n, n2);
    }

    public void setRolloverTime(TimeZone timeZone, int n, int n2) {
        this.setRolloverTimeInternal(timeZone, n, n2);
        this.timeSetProgramatically = true;
    }

    private void setRolloverTimeInternal(TimeZone timeZone, int n, int n2) {
        if (timeZone == null) {
            throw new IllegalArgumentException("timeZone cannot be null.");
        }
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("hour must be between 0 and 23, inclusive.");
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("minute must be between 0 and 59, inclusive.");
        }
        this.timeZone = timeZone;
        this.hour = n;
        this.minute = n2;
    }

    public boolean rolloverNow(Date date, long l) {
        if (this.timeZone == null) {
            throw new IllegalStateException("TimeOfDayRolloverStrategy has not been configured.");
        }
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(date);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l2 = calendar.getTime().getTime();
        while (l2 <= date.getTime()) {
            int n = calendar.get(5);
            calendar.set(5, n + 1);
            l2 = calendar.getTime().getTime();
        }
        long l3 = System.currentTimeMillis();
        return l3 >= l2;
    }
}

