/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.conf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;

public class Configuration {
    private Properties prop = new Properties();
    private Boolean storeOnModify = true;
    private static final String SUFFIX = ".conf";
    private static Hashtable<String, Configuration> cache = new Hashtable();
    private static Configuration mainConfiguration;

    private Configuration(String desired, boolean doCache) throws FileNotFoundException {
        try {
            this.prop.load(new BufferedReader(new FileReader("conf/" + desired + SUFFIX)));
        }
        catch (Exception e) {
            try {
                this.prop.load(new BufferedReader(new FileReader("conf/default/" + desired + SUFFIX)));
            }
            catch (Exception f) {
                throw new FileNotFoundException("Configuration file " + desired + " could not be found.");
            }
        }
        if (doCache) {
            cache.put(this.prop.getProperty("FILENAME"), this);
        }
        if (desired.equals("main")) {
            mainConfiguration = this;
        }
    }

    public static Configuration getConf(String desired) throws FileNotFoundException {
        return Configuration.getConf(desired, true);
    }

    public static Configuration getConf(String desired, boolean doCache) throws FileNotFoundException {
        if (cache.containsKey(desired + SUFFIX)) {
            return cache.get(desired + SUFFIX);
        }
        return new Configuration(desired, doCache);
    }

    public String getProperty(String key) {
        String value = this.prop.getProperty(key);
        if (value == null && this != mainConfiguration) {
            value = mainConfiguration.getProperty(key);
        }
        return value;
    }

    public synchronized void setStoreOnModify(boolean storeOnModify) {
        this.storeOnModify = storeOnModify;
    }

    public synchronized void setProperty(String key, String value) throws IOException {
        String previousValue = this.prop.getProperty(key);
        if (previousValue == null && mainConfiguration.getProperty(key) != null) {
            mainConfiguration.setProperty(key, previousValue);
            return;
        }
        if (!key.equals("FILENAME")) {
            this.prop.setProperty(key, value);
            if (this.storeOnModify.booleanValue()) {
                this.save();
            }
        }
    }

    public synchronized void save() throws IOException {
        this.prop.store(new BufferedWriter(new PrintWriter("conf/" + this.prop.getProperty("FILENAME"))), "Auto stored file");
    }

    public void loadDefault() throws IOException {
        this.prop.load(new BufferedReader(new FileReader("conf/default/" + this.prop.getProperty("FILENAME"))));
    }
}

