/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.db.simpleDB;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;
import java.util.ResourceBundle;
import org.ahunt.simpleRowLog.common.AdminInfo;
import org.ahunt.simpleRowLog.common.AdminPermissionList;
import org.ahunt.simpleRowLog.common.BoatInfo;
import org.ahunt.simpleRowLog.common.BoatStatistic;
import org.ahunt.simpleRowLog.common.DatabaseError;
import org.ahunt.simpleRowLog.common.EntryAlreadyExistsException;
import org.ahunt.simpleRowLog.common.GroupInfo;
import org.ahunt.simpleRowLog.common.GroupStatistic;
import org.ahunt.simpleRowLog.common.MemberInfo;
import org.ahunt.simpleRowLog.common.MemberStatistic;
import org.ahunt.simpleRowLog.common.OutingInfo;
import org.ahunt.simpleRowLog.db.simpleDB.Util;
import org.grlea.log.DebugLevel;
import org.grlea.log.SimpleLogger;

public class Database
implements org.ahunt.simpleRowLog.interfaces.Database {
    private static Database db;
    private static final SimpleLogger log;
    private ResourceBundle rb;
    private OutingManager outingManager;
    private String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private String dbName = "srl";
    private String connectionURL = "jdbc:derby:" + this.dbName + ";create=true";
    private Connection con;
    private PreparedStatement psAddBoat;
    private PreparedStatement psGetBoat;
    private PreparedStatement psModifyBoat;
    private PreparedStatement psGetBoats;
    private PreparedStatement psGetBoatsSelection;
    private PreparedStatement psGetBoatStat;
    private PreparedStatement psGetBoatsStats;
    private PreparedStatement psAddMember;
    private PreparedStatement psGetMember;
    private PreparedStatement psModifyMember;
    private PreparedStatement psGetMembers;
    private PreparedStatement psGetMembersSelection;
    private PreparedStatement psAddGroup;
    private PreparedStatement psGetGroup;
    private PreparedStatement psModifyGroup;
    private PreparedStatement psGetDefaultGroup;
    private PreparedStatement psGetGroups;
    private PreparedStatement psAddAdmin;

    public static synchronized Database getInstance() {
        if (db != null) {
            return db;
        }
        return new Database();
    }

    private Database() throws DatabaseError {
        log.entry("Database()");
        System.setProperty("derby.system.home", new File(".").getAbsolutePath() + "/database");
        this.rb = ResourceBundle.getBundle("db");
        log.info("Resource Bundle loaded.");
        try {
            Class.forName(this.driver).newInstance();
            log.info("Loaded db driver.");
        }
        catch (Exception e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("driverError"), e);
        }
        try {
            this.con = DriverManager.getConnection(this.connectionURL);
            log.info("Connected to db.");
        }
        catch (Throwable e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("connectionError"), e);
        }
        try {
            if (this.con.getWarnings() == null) {
                log.info("No database existed beforehand: setting up.");
                this.createDatabase();
            } else {
                log.info("Database previously existed and will be used.");
            }
        }
        catch (SQLException e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("setupError"), e);
        }
        catch (IOException e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("scriptError"), e);
        }
        try {
            log.info("Creating OutingManager.");
            this.outingManager = new OutingManager();
            log.info("Outing manager set up");
        }
        catch (SQLException e) {
            log.error("Problem creating outing Manager.");
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("scriptError"), e);
        }
        catch (IOException e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("scriptError"), e);
        }
        db = this;
        log.exit("Database()");
    }

    private void createDatabase() throws SQLException, IOException {
        log.entry("createDatabase()");
        log.info("Running db setup scripts.");
        Statement s = this.con.createStatement();
        log.debugObject("con.getAutoCommit()", this.con.getAutoCommit());
        log.debug("setupGroups");
        s.execute(Util.loadScript("setupGroups"));
        log.debug("setupGroupTrigger1");
        s.execute(Util.loadScript("setupGroupTrigger1"));
        log.debug("setupGroupTrigger2");
        s.execute(Util.loadScript("setupGroupTrigger2"));
        log.debug("setupMembers");
        s.execute(Util.loadScript("setupMembers"));
        log.debug("setupBoats");
        s.execute(Util.loadScript("setupBoats"));
        log.debug("setupAdmins");
        s.execute(Util.loadScript("setupAdmins"));
        log.debug("setupAdminsTrigger1");
        s.execute(Util.loadScript("setupAdminsTrigger1"));
        log.debug("setupAdminsTrigger2");
        s.execute(Util.loadScript("setupAdminsTrigger2"));
        log.debug("setupAdminsPermissions");
        log.info("Beginning creation of default data.");
        this.createDefaultData();
        log.info("Default data created successfully.");
        log.exit("createDatabase()");
    }

    private void createDefaultData() throws SQLException {
        log.entry("createDefaultData()");
        log.info("Setting up default groups and users.");
        int guestGroup = this.addGroup(this.rb.getString("guestGroupName"), this.rb.getString("guestGroupDescription"), new Color(-16776961), true);
        int deletedGroup = this.addGroup(this.rb.getString("deletedGroupName"), this.rb.getString("deletedGroupDescription"), new Color(-16776961), false);
        this.addGroup(this.rb.getString("memberGroupName"), this.rb.getString("memberGroupDescription"), new Color(-16776961), false);
        try {
            this.addMember(this.rb.getString("guestMemberName"), "", new Date(0L), guestGroup);
            this.addMember(this.rb.getString("deletedMemberName"), "", new Date(0L), deletedGroup);
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            // empty catch block
        }
        this.addBoat(this.rb.getString("otherBoat"), "", true);
        this.addAdmin("root", "root", "Rootable", true, "Default admin");
        log.exit("createDefaultData()");
    }

    @Override
    public void addBoat(String name, String type, boolean inHouse) throws DatabaseError {
        log.verbose("addBoat(...)");
        if (name == null | name.length() == 0) {
            throw new IllegalArgumentException("Boat name cannot be null or empty");
        }
        try {
            if (this.psAddBoat == null) {
                this.psAddBoat = this.con.prepareStatement("INSERT INTO boats (name, type,inHouse) VALUES (?,?,?)");
            }
            this.psAddBoat.setString(1, name);
            this.psAddBoat.setString(2, type);
            this.psAddBoat.setBoolean(3, inHouse);
            this.psAddBoat.execute();
        }
        catch (SQLException e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public BoatInfo getBoat(String name) throws DatabaseError {
        log.verbose("getBoat(String)");
        try {
            if (this.psGetBoat == null) {
                this.psGetBoat = this.con.prepareStatement("SELECT * FROM boats WHERE name = ?");
            }
            this.psGetBoat.setString(1, name);
            this.psGetBoat.execute();
            ResultSet rs = this.psGetBoat.getResultSet();
            if (rs.next()) {
                return new BoatInfo(rs.getString("name"), rs.getString("type"), rs.getBoolean("inHouse"));
            }
            return null;
        }
        catch (SQLException e) {
            log.error("Failed to get boat: " + name);
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public void modifyBoat(BoatInfo old, String name, String type, boolean inHouse) throws DatabaseError {
        log.verbose("modifyBoat(...)");
        if (old == null) {
            throw new IllegalArgumentException("old cannot be null");
        }
        if (name == null | name.length() == 0) {
            throw new IllegalArgumentException("Boat name cannot be null or empty");
        }
        try {
            if (this.psModifyBoat == null) {
                this.psModifyBoat = this.con.prepareStatement("UPDATE boats SET name=?, type=?, inHouse=? WHERE name = ?");
            }
            this.psModifyBoat.setString(4, old.getName());
            this.psModifyBoat.setString(1, name);
            this.psModifyBoat.setString(2, type);
            this.psModifyBoat.setBoolean(3, inHouse);
            this.psModifyBoat.execute();
        }
        catch (SQLException e) {
            log.error("Failed to modify boat: " + name);
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public BoatInfo[] getBoats() throws DatabaseError {
        log.verbose("getBoats()");
        try {
            if (this.psGetBoats == null) {
                this.psGetBoats = this.con.prepareStatement("SELECT name FROM boats ORDER BY name");
            }
            this.psGetBoats.execute();
            ResultSet rs = this.psGetBoats.getResultSet();
            ArrayList<BoatInfo> a = new ArrayList<BoatInfo>();
            while (rs.next()) {
                a.add(this.getBoat(rs.getString("name")));
            }
            log.verbose("Data gotten, returning boats");
            if (a.size() == 0) {
                return null;
            }
            return a.toArray(new BoatInfo[0]);
        }
        catch (SQLException e) {
            log.error("Error getting boats");
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public BoatInfo[] getBoats(boolean inHouse) throws DatabaseError {
        log.verbose("getBoats(boolean)");
        try {
            if (this.psGetBoatsSelection == null) {
                this.psGetBoatsSelection = this.con.prepareStatement("SELECT name FROM boats WHERE inHouse = ? ORDER BY name");
            }
            this.psGetBoatsSelection.setBoolean(1, inHouse);
            this.psGetBoatsSelection.execute();
            ResultSet rs = this.psGetBoatsSelection.getResultSet();
            ArrayList<BoatInfo> a = new ArrayList<BoatInfo>();
            while (rs.next()) {
                a.add(this.getBoat(rs.getString("name")));
            }
            log.verbose("Data gotten, returning groups");
            if (a.size() == 0) {
                return null;
            }
            return a.toArray(new BoatInfo[0]);
        }
        catch (SQLException e) {
            log.error("Error getting groups");
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public BoatStatistic getBoatStatistic(String name) {
        return null;
    }

    @Override
    public BoatStatistic[] getBoatsStatistics() {
        return null;
    }

    @Override
    public int addMember(String surname, String forename, java.util.Date dob, int group) throws DatabaseError, EntryAlreadyExistsException {
        log.verbose("addMember(... " + group + ")");
        if (surname == null | surname.length() == 0) {
            throw new IllegalArgumentException("Surname cannot be null or zero length");
        }
        if (dob == null) {
            throw new IllegalArgumentException("dob cannot be null");
        }
        if (this.getGroup(group) == null) {
            throw new IllegalArgumentException("group must correspond to an existing group.");
        }
        try {
            if (this.psAddMember == null) {
                this.psAddMember = this.con.prepareStatement("INSERT INTO members (surname, forename, dob, usergroup) VALUES (?, ?, ?, ?)", 1);
            }
            this.psAddMember.setString(1, surname);
            this.psAddMember.setString(2, forename);
            this.psAddMember.setDate(3, new Date(dob.getTime()));
            this.psAddMember.setInt(4, group);
            this.psAddMember.execute();
            ResultSet rs = this.psAddMember.getGeneratedKeys();
            if (rs.next()) {
                return rs.getInt(1);
            }
            throw new DatabaseError(this.rb.getString("commandError"), null);
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new EntryAlreadyExistsException("A member named " + surname + ":" + forename + " with dob " + dob + " already is in the database.", e);
        }
        catch (SQLException e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public MemberInfo getMember(int id) throws DatabaseError {
        log.verbose("getMember(int)");
        try {
            if (this.psGetMember == null) {
                this.psGetMember = this.con.prepareStatement("SELECT * FROM members WHERE id = ?");
            }
            this.psGetMember.setInt(1, id);
            ResultSet res = this.psGetMember.executeQuery();
            if (res.next()) {
                return new MemberInfo(id, res.getString("surname"), res.getString("forename"), res.getDate("dob"), this.getGroup(res.getInt("usergroup")));
            }
            return null;
        }
        catch (SQLException e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public void modifyMember(int id, String surname, String forename, java.util.Date dob, int group) throws DatabaseError {
        log.verbose("modifyMember(...)");
        if (this.getMember(id) == null) {
            throw new IllegalArgumentException("member must already exist in order to modify");
        }
        if (surname == null | surname.length() == 0) {
            throw new IllegalArgumentException("surname cannot be null or zero length");
        }
        if (dob == null) {
            throw new IllegalArgumentException("dob cannot be null");
        }
        if (this.getGroup(group) == null) {
            throw new IllegalArgumentException("group must correspond to an existing group.");
        }
        try {
            if (this.psModifyMember == null) {
                this.psModifyMember = this.con.prepareStatement("UPDATE members SET surname=?, forename=?, dob=?, usergroup=? WHERE id = ?");
            }
            this.psModifyMember.setString(1, surname);
            this.psModifyMember.setString(2, forename);
            this.psModifyMember.setDate(3, new Date(dob.getTime()));
            this.psModifyMember.setInt(4, group);
            this.psModifyMember.setInt(5, id);
            this.psModifyMember.execute();
        }
        catch (SQLException e) {
            log.error("Failed to modify member.");
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public MemberInfo[] getMembers() throws DatabaseError {
        log.verbose("getMembers()");
        try {
            if (this.psGetMembers == null) {
                this.psGetMembers = this.con.prepareStatement("SELECT * from members");
            }
            this.psGetMembers.execute();
            ResultSet rs = this.psGetMembers.getResultSet();
            ArrayList<MemberInfo> a = new ArrayList<MemberInfo>();
            while (rs.next()) {
                a.add(new MemberInfo(rs.getInt("id"), rs.getString("surname"), rs.getString("forename"), new java.util.Date(0L), this.getGroup(rs.getInt("usergroup"))));
            }
            if (a.size() == 0) {
                return null;
            }
            return a.toArray(new MemberInfo[0]);
        }
        catch (SQLException e) {
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public MemberInfo[] getMembers(int sorting) throws DatabaseError {
        return null;
    }

    @Override
    public MemberStatistic getMemberStatistics(int id) throws DatabaseError {
        return this.outingManager.getMemberStatistics(id);
    }

    @Override
    public MemberStatistic[] getMembersStatistics() {
        return null;
    }

    @Override
    public MemberStatistic[] getMembersStatistics(int sorting) {
        return null;
    }

    @Override
    public int addGroup(String name, String description, Color colour, boolean isDefault) throws DatabaseError {
        log.verbose("addGroup(...)");
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null when adding a group");
        }
        if (colour == null) {
            throw new IllegalArgumentException("colour cannot be null when adding a group");
        }
        try {
            if (this.psAddGroup == null) {
                this.psAddGroup = this.con.prepareStatement("INSERT INTO groups(name, description, colour, isDefault) VALUES (?, ?, ?, ?)", 1);
            }
            this.psAddGroup.setString(1, name);
            this.psAddGroup.setString(2, description);
            this.psAddGroup.setInt(3, colour.getRGB());
            this.psAddGroup.setBoolean(4, isDefault);
            this.psAddGroup.execute();
            ResultSet rs = this.psAddGroup.getGeneratedKeys();
            if (rs.next()) {
                return rs.getInt(1);
            }
            throw new DatabaseError(this.rb.getString("commandError"), null);
        }
        catch (SQLException e) {
            log.error("Error setting up group.");
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public GroupInfo getGroup(int id) throws DatabaseError {
        log.verbose("getGroup(" + id + ")");
        try {
            if (this.psGetGroup == null) {
                this.psGetGroup = this.con.prepareStatement("SELECT * FROM groups WHERE id = ?");
            }
            this.psGetGroup.setInt(1, id);
            this.psGetGroup.execute();
            ResultSet rs = this.psGetGroup.getResultSet();
            if (!rs.next()) {
                return null;
            }
            String name = rs.getString("name");
            String description = rs.getString("description");
            Color c = new Color(rs.getInt("colour"));
            boolean isDefault = rs.getBoolean("isDefault");
            log.verbose("Data gotten, returning group");
            return new GroupInfo(id, name, description, c, isDefault);
        }
        catch (SQLException e) {
            log.error("Error getting group " + id);
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public void modifyGroup(int id, String name, String description, Color colour, boolean isDefault) throws DatabaseError {
        log.verbose("Modifying group " + id);
        if (this.getGroup(id) == null) {
            throw new IllegalArgumentException("id must be a valid group");
        }
        if (name == null | name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or zero length");
        }
        if (colour == null) {
            throw new IllegalArgumentException("colour cannot be null");
        }
        try {
            if (this.psModifyGroup == null) {
                this.psModifyGroup = this.con.prepareStatement("UPDATE groups name = ?,description = ?, colour = ?, isDefault = ? WHERE id = ?");
            }
            this.psModifyGroup.setString(1, name);
            this.psModifyGroup.setString(2, description);
            this.psModifyGroup.setInt(3, colour.getRGB());
            this.psModifyGroup.setBoolean(4, isDefault);
            this.psModifyGroup.setInt(5, id);
            this.psModifyGroup.execute();
        }
        catch (SQLException e) {
            log.error("Error modifying group " + id);
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public GroupInfo[] getGroups() throws DatabaseError {
        log.verbose("getGroups()");
        try {
            if (this.psGetGroups == null) {
                this.psGetGroups = this.con.prepareStatement("SELECT id FROM groups");
            }
            this.psGetGroups.execute();
            ResultSet rs = this.psGetGroups.getResultSet();
            ArrayList<GroupInfo> a = new ArrayList<GroupInfo>();
            while (rs.next()) {
                a.add(this.getGroup(rs.getInt("id")));
            }
            log.verbose("Data gotten, returning groups");
            if (a.size() == 0) {
                return null;
            }
            return a.toArray(new GroupInfo[0]);
        }
        catch (SQLException e) {
            log.error("Error getting groups");
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public GroupInfo getDefaultGroup() throws DatabaseError {
        log.verbose("getDefaultGroup()");
        try {
            if (this.psGetDefaultGroup == null) {
                this.psGetDefaultGroup = this.con.prepareStatement("SELECT * FROM groups WHERE isDefault = 1");
                this.psGetDefaultGroup.setMaxRows(1);
            }
            this.psGetDefaultGroup.execute();
            ResultSet rs = this.psGetDefaultGroup.getResultSet();
            if (!rs.next()) {
                throw new DatabaseError("No default group. Major error.", null);
            }
            int id = rs.getInt("id");
            String name = rs.getString("name");
            String description = rs.getString("description");
            Color c = new Color(rs.getInt("colour"));
            log.verbose("Data gotten, returning group");
            return new GroupInfo(id, name, description, c, true);
        }
        catch (SQLException e) {
            log.error("Error getting default group.");
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
    }

    @Override
    public GroupStatistic getGroupStatistic(int id) throws DatabaseError {
        return null;
    }

    @Override
    public GroupStatistic[] getGroupsStatistics() throws DatabaseError {
        return null;
    }

    @Override
    public long addOuting(java.util.Date date, int[] rowers, int cox, java.util.Date timeOut, java.util.Date timeIn, String comment, String dest, String boat, int distance) throws DatabaseError {
        return this.outingManager.addOuting(date, rowers, cox, timeOut, timeIn, comment, dest, boat, distance);
    }

    @Override
    public OutingInfo[] getOutings(java.util.Date date) throws DatabaseError {
        return this.outingManager.getOutings(date);
    }

    @Override
    public void modifyOuting(long id, long created, int[] rowers, int cox, java.util.Date out, java.util.Date in, String comment, String destination, String boat, int distance) {
        this.outingManager.modifyOuting(id, created, rowers, cox, out, in, comment, destination, boat, distance);
    }

    @Override
    public void addAdmin(String username, String password, String name, boolean isRoot, String comment) {
        log.entry("addAdmin(...)");
        Random r = new Random();
        byte[] salt = new byte[64];
        r.nextBytes(salt);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(salt);
            byte[] hash = digest.digest(password.getBytes("UTF-16"));
            if (this.psAddAdmin == null) {
                this.psAddAdmin = this.con.prepareStatement("INSERT INTO admins (username, password, salt, name, isRoot, comment) VALUES (?,?,?,?,?,?)");
            }
            this.psAddAdmin.setString(1, username);
            this.psAddAdmin.setString(2, new String(hash, Charset.forName("UTF-16")));
            this.psAddAdmin.setString(3, new String(salt, Charset.forName("UTF-16")));
            this.psAddAdmin.setString(4, name);
            this.psAddAdmin.setBoolean(5, isRoot);
            this.psAddAdmin.setString(6, comment);
            this.psAddAdmin.execute();
            this.psAddAdmin.clearParameters();
        }
        catch (SQLException e) {
            log.error("Error adding new admin.");
            log.errorException(e);
            throw new DatabaseError(this.rb.getString("commandError"), e);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public AdminInfo getAdmin(String username) {
        return null;
    }

    public AdminPermissionList getAdminPermissions(String username) {
        return null;
    }

    @Override
    public AdminInfo[] getAdmins() {
        return null;
    }

    public void modifyAdmin(String formerUsername) {
    }

    public void removeAdmin(String username) {
    }

    public AdminInfo authenticateAdmin(String username, String password) {
        return null;
    }

    static {
        log = new SimpleLogger(Database.class);
    }

    private class OutingStatementSet {
        private long lastUsed;
        private Integer year;
        private PreparedStatement psGetOutings;
        private PreparedStatement psAddOuting;
        private PreparedStatement psModifyOuting;
        private PreparedStatement psGetMemberStatistics;

        public OutingStatementSet(Integer year, Hashtable<Integer, OutingStatementSet> statementCache) throws SQLException {
            log.entry("OutingStatementSet(Integer, HashTable");
            try {
                log.info("Trying to create a new table for year " + year + ".");
                Database.this.con.createStatement().execute(MessageFormat.format(Util.loadScript("createOutings"), year.toString()));
                log.info("New Outings table for year " + year + " created.");
            }
            catch (SQLException e) {
                log.info("Outings table for this year already exists.");
                log.dbe(DebugLevel.L6_VERBOSE, e);
            }
            catch (IOException e) {
                // empty catch block
            }
            log.info("creating psGetOutings");
            this.psGetOutings = Database.this.con.prepareStatement(MessageFormat.format("SELECT * FROM outings_{0} WHERE day = ? ORDER BY time_out", year.toString()));
            this.psAddOuting = Database.this.con.prepareStatement(MessageFormat.format("INSERT INTO outings_{0} (day, rower1, rower2, rower3, rower4, rower5, rower6, rower7, rower8, cox, time_out, time_in, comment, destination,boat, distance) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", year.toString()));
            this.psModifyOuting = Database.this.con.prepareStatement(MessageFormat.format("UPDATE outings_{0} SET rower1 = ?, rower2 = ?, rower3 = ?, rower4 = ?, rower5 = ?, rower6 = ?, rower7 = ?, rower8 = ?, cox = ?, time_out = ?, time_in = ?, comment = ?, destination = ?, boat = ?, distance = ? WHERE id = ?", year.toString()));
            this.psGetMemberStatistics = Database.this.con.prepareStatement(MessageFormat.format("SELECT * FROM outings_{0} WHERE rower1 = ? OR rower2 = ? OR rower3 = ? OR rower4 = ? OR rower5 = ? OR rower6 = ? OR rower7 = ? OR rower8 = ? OR cox = ?", year.toString()));
            this.updateTime();
            log.exit("OutingStatementSet(Integer, HashTable");
        }

        public PreparedStatement getPreparedStatement(OutingStatementType typ) {
            this.updateTime();
            if (typ == OutingStatementType.GET_OUTINGS) {
                return this.psGetOutings;
            }
            if (typ == OutingStatementType.ADD_OUTING) {
                return this.psAddOuting;
            }
            if (typ == OutingStatementType.MODIFY_OUTING) {
                return this.psModifyOuting;
            }
            if (typ == OutingStatementType.GET_MEMBER_STATISTICS) {
                return this.psGetMemberStatistics;
            }
            return null;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public Integer getYear() {
            return this.year;
        }

        private void updateTime() {
            this.lastUsed = new java.util.Date().getTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            log.info("Closing OutingStatementSet for year " + this.year.toString());
            try {
                this.psGetOutings.close();
                this.psAddOuting.close();
                this.psModifyOuting.close();
            }
            catch (SQLException e) {
                log.errorException(e);
            }
            this.year = null;
        }
    }

    private static enum OutingStatementType {
        GET_OUTINGS,
        ADD_OUTING,
        MODIFY_OUTING,
        GET_MEMBER_STATISTICS;

    }

    private class OutingManager
    implements Runnable {
        private Hashtable<Integer, OutingStatementSet> statementCache = new Hashtable();

        public OutingManager() throws SQLException, IOException {
            log.entry("OutingManager.OutingManager()");
            new Thread(this).start();
            log.exit("OutingManager.OutingManager()");
        }

        public OutingInfo[] getOutings(java.util.Date date) throws DatabaseError {
            log.entry("OutingManager.getOutings()");
            log.info("Getting outings for " + date.toString());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            ArrayList<OutingInfo> array = new ArrayList<OutingInfo>();
            try {
                PreparedStatement ps = this.getOutingStatementSet(cal.get(1)).getPreparedStatement(OutingStatementType.GET_OUTINGS);
                ps.setDate(1, new Date(date.getTime()));
                ResultSet res = ps.executeQuery();
                log.info("Got ResultSet for that date, now processing.");
                while (res.next()) {
                    long out_id = res.getLong("id");
                    log.verbose("Processing outing with id=" + out_id);
                    MemberInfo[] seats = new MemberInfo[8];
                    for (int i = 0; i < 8; ++i) {
                        int member_id = res.getInt("rower" + (i + 1));
                        if (member_id == 0) continue;
                        seats[i] = Database.this.getMember(member_id);
                    }
                    Date day = res.getDate("day");
                    MemberInfo cox = null;
                    int coxID = res.getInt("cox");
                    if (coxID != 0) {
                        cox = Database.this.getMember(coxID);
                    }
                    java.util.Date timeOut = new java.util.Date(res.getLong("time_out"));
                    java.util.Date timeIn = null;
                    long timeInL = res.getLong("time_in");
                    if (timeInL != 0L) {
                        timeIn = new java.util.Date(timeInL);
                    }
                    String comment = res.getString("comment");
                    String destination = res.getString("destination");
                    BoatInfo boat = Database.this.getBoat(res.getString("boat"));
                    int distance = res.getInt("distance");
                    array.add(new OutingInfo(out_id, day, seats, cox, timeOut, timeIn, comment, destination, boat, distance));
                }
            }
            catch (SQLException e) {
                log.errorException(e);
                throw new DatabaseError(Database.this.rb.getString("commandError"), e);
            }
            log.exit("OutingManager.getOutings()");
            return array.toArray(new OutingInfo[0]);
        }

        public long addOuting(java.util.Date date, int[] rowers, int cox, java.util.Date timeOut, java.util.Date timeIn, String comment, String dest, String boat, int distance) throws DatabaseError {
            log.entry("OutingManager.addOuting(...)");
            log.info("Adding outing");
            if (date == null) {
                throw new IllegalArgumentException("Date cannot be null");
            }
            if (Database.this.getMember(rowers[0]) == null) {
                throw new IllegalArgumentException("rowers[0] must be a valid member");
            }
            if (timeOut == null) {
                throw new IllegalArgumentException("timeOut cannot be null");
            }
            if (boat == null || boat.length() == 0 || Database.this.getBoat(boat) == null) {
                throw new IllegalArgumentException("boat must be a valid boat, cannot be null");
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            try {
                int i;
                PreparedStatement ps = this.getOutingStatementSet(cal.get(1)).getPreparedStatement(OutingStatementType.ADD_OUTING);
                ps.setDate(1, new Date(date.getTime()));
                ps.setInt(2, rowers[0]);
                for (i = 0; i < rowers.length - 1; i = (int)((short)(i + 1))) {
                    if (rowers[i + 1] != 0) {
                        ps.setInt(i + 3, rowers[i + 1]);
                        continue;
                    }
                    ps.setNull(i + 3, 5);
                }
                while (i < 7) {
                    ps.setNull(i + 3, 5);
                    i = (short)(i + 1);
                }
                if (cox != 0) {
                    ps.setInt(10, cox);
                } else {
                    ps.setNull(10, 4);
                }
                ps.setLong(11, timeOut.getTime());
                if (timeIn != null) {
                    ps.setLong(12, timeIn.getTime());
                } else {
                    ps.setNull(12, -5);
                }
                if (comment != null) {
                    ps.setString(13, comment);
                } else {
                    ps.setNull(13, 12);
                }
                if (dest != null) {
                    ps.setString(14, dest);
                } else {
                    ps.setNull(14, 12);
                }
                ps.setString(15, boat);
                if (distance != 0) {
                    ps.setInt(16, distance);
                } else {
                    ps.setNull(16, 4);
                }
                ps.execute();
            }
            catch (SQLException e) {
                log.errorException(e);
                throw new DatabaseError(Database.this.rb.getString("commandError"), e);
            }
            log.exit("OutingManager.addOuting(...)");
            return 0L;
        }

        public void modifyOuting(long id, long day, int[] rowers, int cox, java.util.Date timeOut, java.util.Date timeIn, String comment, String destination, String boat, int distance) {
            log.entry("OutingManager.modifyOuting(...)");
            log.info("Adding outing");
            if (Database.this.getMember(rowers[0]) == null) {
                throw new IllegalArgumentException("rowers[0] must be a valid member");
            }
            if (timeOut == null) {
                throw new IllegalArgumentException("timeOut cannot be null");
            }
            if (boat == null || boat.length() == 0 || Database.this.getBoat(boat) == null) {
                throw new IllegalArgumentException("boat must be a valid boat, cannot be null");
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new java.util.Date(day));
            try {
                int i;
                PreparedStatement ps = this.getOutingStatementSet(cal.get(1)).getPreparedStatement(OutingStatementType.MODIFY_OUTING);
                ps.setLong(16, id);
                ps.setInt(1, rowers[0]);
                for (i = 0; i < rowers.length - 1; i = (int)((short)(i + 1))) {
                    if (rowers[i + 1] != 0) {
                        ps.setInt(i + 2, rowers[i + 1]);
                        continue;
                    }
                    ps.setNull(i + 2, 5);
                }
                while (i < 7) {
                    ps.setNull(i + 2, 5);
                    i = (short)(i + 1);
                }
                if (cox != 0) {
                    ps.setInt(9, cox);
                } else {
                    ps.setNull(9, 4);
                }
                ps.setLong(10, timeOut.getTime());
                if (timeIn != null) {
                    ps.setLong(11, timeIn.getTime());
                } else {
                    ps.setNull(11, -5);
                }
                if (comment != null) {
                    ps.setString(12, comment);
                } else {
                    ps.setNull(12, 12);
                }
                if (destination != null) {
                    ps.setString(13, destination);
                } else {
                    ps.setNull(13, 12);
                }
                ps.setString(14, boat);
                if (distance != 0) {
                    ps.setInt(15, distance);
                } else {
                    ps.setNull(15, 4);
                }
                ps.execute();
            }
            catch (SQLException e) {
                log.errorException(e);
                throw new DatabaseError(Database.this.rb.getString("commandError"), e);
            }
            log.exit("OutingManager.addOuting(...)");
        }

        public MemberStatistic getMemberStatistics(int id) throws DatabaseError {
            log.entry("OutingManager.getMemberStatistics()");
            log.info("Getting statistics for " + id);
            MemberInfo member = Database.this.getMember(id);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new java.util.Date());
            int totalDistanceThisYear = 0;
            int totalDistanceLastYear = 0;
            int totalOutingsThisYear = 0;
            int totalOutingsLastYear = 0;
            try {
                PreparedStatement ps = this.getOutingStatementSet(cal.get(1)).getPreparedStatement(OutingStatementType.GET_OUTINGS);
                for (int i = 1; i < 10; ++i) {
                    ps.setInt(i, id);
                }
                ResultSet res = ps.executeQuery();
                log.info("Got ResultSet for that member, now processing.");
                while (res.next()) {
                    totalDistanceThisYear += res.getInt("distance");
                    ++totalOutingsThisYear;
                }
                ps = this.getOutingStatementSet(cal.get(1) - 1).getPreparedStatement(OutingStatementType.GET_OUTINGS);
                for (int i = 1; i < 10; ++i) {
                    ps.setInt(i, id);
                }
                res = ps.executeQuery();
                log.info("Got ResultSet for that member, now processing.");
                while (res.next()) {
                    totalDistanceLastYear += res.getInt("distance");
                    ++totalOutingsLastYear;
                }
            }
            catch (SQLException e) {
                log.errorException(e);
                throw new DatabaseError(Database.this.rb.getString("commandError"), e);
            }
            log.exit("OutingManager.getMemberStatistics(int id)");
            return new MemberStatistic(id, member.getSurname(), member.getForename(), member.getDob(), member.getGroupInfo(), totalOutingsThisYear, totalDistanceThisYear, totalOutingsLastYear, totalDistanceLastYear);
        }

        private OutingStatementSet getOutingStatementSet(int year) throws SQLException {
            int y = new Integer(year);
            if (this.statementCache.contains(y)) {
                return this.statementCache.get(y);
            }
            return new OutingStatementSet(y, this.statementCache);
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(900000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Integer year = GregorianCalendar.getInstance().get(1);
                long now = new java.util.Date().getTime();
                Enumeration<OutingStatementSet> e = this.statementCache.elements();
                while (true) {
                    if (!e.hasMoreElements()) continue block2;
                    OutingStatementSet os = e.nextElement();
                    if (os.getLastUsed() + 1200000L >= now || os.getYear().equals(year)) continue;
                    this.statementCache.remove(os.getYear());
                    os.close();
                }
                break;
            }
        }
    }
}

