/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.gui.simpleGUI;

import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.ahunt.simpleRowLog.common.EntryAlreadyExistsException;
import org.ahunt.simpleRowLog.common.Util;
import org.ahunt.simpleRowLog.conf.Configuration;
import org.ahunt.simpleRowLog.gui.simpleGUI.ErrorHandler;
import org.ahunt.simpleRowLog.interfaces.Database;

public class AddMemberDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Database db;
    private Configuration conf;
    private int createdMemberId;
    private ResourceBundle loc = ResourceBundle.getBundle("gui");
    private ResourceBundle locCommon = ResourceBundle.getBundle("common");
    private JPanel entryPanel = new JPanel();
    private TitledBorder entryPanelBorder;
    private JLabel surnameEntryLabel = new JLabel();
    private JTextField surnameEntry = new JTextField(25);
    private JLabel forenameEntryLabel = new JLabel();
    private JTextField forenameEntry = new JTextField(25);
    private JLabel dobEntryLabel = new JLabel();
    private JDateChooser dobEntry = new JDateChooser();
    private JButton cancelButton = new JButton();
    private JButton saveButton = new JButton();

    public AddMemberDialog(Database db) {
        this.db = db;
        try {
            this.conf = Configuration.getConf("simpleGUI");
        }
        catch (FileNotFoundException e) {
            ErrorHandler.handleError(e);
        }
        this.entryPanelBorder = new TitledBorder(new LineBorder(Color.BLACK), "");
        this.entryPanel.setBorder(this.entryPanelBorder);
        this.setModal(true);
        NameEntryListener nel = new NameEntryListener(this.surnameEntry);
        this.surnameEntry.addFocusListener(nel);
        this.surnameEntry.addMouseListener(nel);
        nel = new NameEntryListener(this.forenameEntry);
        this.forenameEntry.addFocusListener(nel);
        this.forenameEntry.addMouseListener(nel);
        this.setupLayout();
        ButtonListener bl = new ButtonListener();
        this.cancelButton.addActionListener(bl);
        this.saveButton.addActionListener(bl);
    }

    private void setupLayout() {
        GroupLayout l = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(l);
        l.setAutoCreateGaps(true);
        l.setAutoCreateContainerGaps(true);
        l.setHorizontalGroup(l.createParallelGroup().addComponent(this.entryPanel).addGroup(l.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cancelButton).addComponent(this.saveButton)));
        l.setVerticalGroup(l.createSequentialGroup().addComponent(this.entryPanel).addGroup(l.createParallelGroup().addComponent(this.cancelButton).addComponent(this.saveButton)));
        GroupLayout r = new GroupLayout(this.entryPanel);
        this.entryPanel.setLayout(r);
        r.setAutoCreateGaps(true);
        r.setAutoCreateContainerGaps(true);
        r.setHorizontalGroup(r.createSequentialGroup().addGroup(r.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.forenameEntryLabel).addComponent(this.surnameEntryLabel).addComponent(this.dobEntryLabel)).addGroup(r.createParallelGroup().addComponent(this.forenameEntry).addComponent(this.surnameEntry).addComponent(this.dobEntry)));
        r.setVerticalGroup(r.createSequentialGroup().addGroup(r.createParallelGroup().addComponent(this.forenameEntryLabel).addComponent(this.forenameEntry)).addGroup(r.createParallelGroup().addComponent(this.surnameEntryLabel).addComponent(this.surnameEntry)).addGroup(r.createParallelGroup().addComponent(this.dobEntryLabel).addComponent(this.dobEntry)));
    }

    public int addMember(String surname, String forename) {
        this.createdMemberId = 0;
        this.dobEntry.setDateFormatString(this.conf.getProperty("srl.date_format"));
        this.updateLocalisation();
        this.pack();
        this.setResizable(false);
        this.surnameEntry.setText(surname);
        this.forenameEntry.setText(forename);
        this.dobEntry.setDate(null);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
        this.setVisible(true);
        this.setResizable(true);
        return this.createdMemberId;
    }

    public int addMember() {
        return this.addMember(null, null);
    }

    public void updateLocalisation() {
        this.setTitle(this.loc.getString("addMember.title"));
        this.entryPanelBorder.setTitle(this.loc.getString("addMember.entryFrame"));
        this.surnameEntryLabel.setText(this.locCommon.getString("surname") + ":");
        this.forenameEntryLabel.setText(this.locCommon.getString("forename") + ":");
        this.dobEntryLabel.setText(this.locCommon.getString("dob") + ":");
        this.cancelButton.setText(this.locCommon.getString("cancel"));
        this.saveButton.setText(this.locCommon.getString("save"));
    }

    private class NameEntryListener
    implements FocusListener,
    MouseListener {
        private JTextField entry;

        public NameEntryListener(JTextField entry) {
            this.entry = entry;
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.entry.setText(Util.capitaliseName(this.entry.getText()));
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            this.focusLost(null);
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == AddMemberDialog.this.cancelButton) {
                AddMemberDialog.this.setVisible(false);
            } else if (arg0.getSource() == AddMemberDialog.this.saveButton) {
                try {
                    AddMemberDialog.this.createdMemberId = AddMemberDialog.this.db.addMember(AddMemberDialog.this.surnameEntry.getText(), AddMemberDialog.this.forenameEntry.getText(), AddMemberDialog.this.dobEntry.getDate(), AddMemberDialog.this.db.getDefaultGroup().getId());
                    AddMemberDialog.this.setVisible(false);
                }
                catch (EntryAlreadyExistsException e) {
                    String message = "<html><table><tr><td width=300 align=\"left\">" + MessageFormat.format(AddMemberDialog.this.loc.getString("addMember.memberAlreadyExists"), "<i>" + MessageFormat.format(AddMemberDialog.this.conf.getProperty("srl.name_format"), AddMemberDialog.this.surnameEntry.getText(), AddMemberDialog.this.forenameEntry.getText()) + "</i>", "<i>" + new SimpleDateFormat(AddMemberDialog.this.conf.getProperty("srl.date_format")).format(AddMemberDialog.this.dobEntry.getDate()) + "</i>") + "</td></tr></table></html>";
                    JOptionPane.showMessageDialog(null, message, AddMemberDialog.this.loc.getString("addMember.memberAlreadyExists.title"), 0);
                }
            }
        }
    }
}

