/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.gui.simpleGUI;

import com.toedter.calendar.JSpinnerDateEditor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ahunt.simpleRowLog.conf.Configuration;
import org.ahunt.simpleRowLog.gui.simpleGUI.ErrorHandler;

public class DaySelectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Configuration conf;
    private ResourceBundle loc = ResourceBundle.getBundle("gui");
    private JSpinnerDateEditor dateChooser = new JSpinnerDateEditor();
    private JButton todayButton = new JButton();

    public DaySelectionPanel() {
        try {
            this.conf = Configuration.getConf("simpleGUI");
        }
        catch (FileNotFoundException e) {
            ErrorHandler.handleError(e);
        }
        this.todayButton.addActionListener(this);
        this.dateChooser.addChangeListener(new DateChangeListener());
        GroupLayout l = new GroupLayout(this);
        this.setLayout(l);
        l.setAutoCreateContainerGaps(true);
        l.setHorizontalGroup(l.createParallelGroup().addComponent(this.dateChooser).addGroup(l.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.todayButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE)));
        l.setVerticalGroup(l.createSequentialGroup().addComponent(this.dateChooser).addComponent(this.todayButton));
        this.dateChooser.setDateFormatString(this.conf.getProperty("srl.date_format"));
        this.updateLocalisation();
        LineBorder b = new LineBorder(Color.BLACK);
        this.setBorder(b);
        this.actionPerformed(null);
        this.setMaximumSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.dateChooser.setDate(new Date());
    }

    public void updateLocalisation() {
        this.todayButton.setText(this.loc.getString("select_today"));
    }

    public void addChangeListener(ChangeListener cl) {
        this.dateChooser.addChangeListener(cl);
    }

    public Date getDate() {
        return this.dateChooser.getDate();
    }

    private class DateChangeListener
    implements ChangeListener {
        private DateChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            Calendar today = Calendar.getInstance();
            today.setTime(new Date());
            Calendar selected = Calendar.getInstance();
            selected.setTime(DaySelectionPanel.this.dateChooser.getDate());
            if (today.get(1) == selected.get(1) && today.get(2) == selected.get(2) && today.get(5) == selected.get(5)) {
                DaySelectionPanel.this.todayButton.setEnabled(false);
            } else {
                DaySelectionPanel.this.todayButton.setEnabled(true);
            }
        }
    }
}

