/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.ahunt.simpleRowLog.Info;
import org.ahunt.simpleRowLog.conf.Configuration;
import org.ahunt.simpleRowLog.db.simpleDB.Database;
import org.ahunt.simpleRowLog.gui.simpleGUI.SimpleGUI;
import org.ahunt.simpleRowLog.launcher.SplashManager;
import org.ahunt.simpleRowLog.launcher.Util;
import org.grlea.log.SimpleLogger;

public class Launch {
    private static final SimpleLogger log = new SimpleLogger(Launch.class);

    public static void main(String[] args) {
        String in;
        log.entry("main");
        log.info("simple rowLog starting");
        ResourceBundle rb = ResourceBundle.getBundle("startup");
        try {
            in = args[0];
            if (in.equals("-h")) {
                Launch.printUsage();
                System.exit(0);
            }
        }
        catch (Exception e) {
            in = "./";
        }
        log.info("Checking data directory");
        Util.setDataDir(new File(in));
        if (!Launch.isValidDir(Util.getDataDir())) {
            Launch.printInvalidDir(in);
            log.error("Invalid data directory.");
            System.exit(1);
        }
        System.out.println(rb.getString("welcome") + "\n" + rb.getString("starting") + "\n[simple rowLog " + Info.getVersion() + " (" + Info.getBuildType() + ")]\n" + Info.getCopyright(true) + "\n" + Info.getLicence());
        SplashManager sm = new SplashManager(10);
        try {
            Configuration conf = Configuration.getConf("main");
            UIManager.setLookAndFeel(conf.getProperty("gui.toolkit"));
            System.out.println(MessageFormat.format(">> " + rb.getString("tkLoaded"), UIManager.getLookAndFeel().getID()));
            log.info(UIManager.getLookAndFeel().getID() + " set as toolkit.");
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, rb.getString("Configuration not found. simple rowLog cannot start. Please ensure that you have an undamaged installation before restarting."), rb.getString("Fatal error!"), 0);
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println(rb.getString("preferred_toolkit_unavailable"));
            log.info("Preferred toolit unavailable, default used.");
        }
        sm.setProgress(30);
        Database db = Database.getInstance();
        sm.setProgress(50);
        SimpleGUI gui = new SimpleGUI(db);
        sm.setProgress(70);
        gui.setVisible(true);
    }

    private static boolean isValidDir(File test) {
        log.entry("isValidDir");
        log.debugObject("test", test);
        return test.isDirectory();
    }

    private static void printInvalidDir(String dir) {
        System.out.println("Sorry, the directory you specified is not a valid directory:\n" + dir);
        System.out.println("\nRun \"simplerowlog -h\" for more information.");
    }

    private static void printUsage() {
        System.out.println("Simply run simplerowlog to use.");
    }
}

