// JSpatialEpidemic - A simulation framework to study the spatial aspect of an epidemic.
// JSpatialEpidemic implements a model from "Bailey N.T.J. (1967), The simulation of
//     sthocastic epidemic in two dimensions, Proc. 5th Berkeley Symp. Math, Stat.
//     and Prob., 4, 237-257, Berkeley & Los Angeles Univ. California"
// Copyright  2003 Pasquale Cariello, Raul Bagni & Roberto Berchi. 
// See Readme for further details.


import swarm.Globals;

public class Start {
    /** The main() function is the top-level place where everything
        starts.  For a typical Swarm simulation, in main() you create
        a toplevel Swarm, let it build and activate, and set it to
        running.  */
    public static void main (String[] args) {
        // Swarm initialization: all Swarm apps must call this first.
        Globals.env.initSwarm ("JSpatialEpidemic", "2.1", "pat.car@tiscalinet.it", args);
        
            ObserverSwarm topLevelSwarm = 
                new ObserverSwarm (Globals.env.globalZone);
            Globals.env.setWindowGeometryRecordName (topLevelSwarm, "topLevelSwarm");
            
            topLevelSwarm.buildObjects ();
            topLevelSwarm.buildActions ();
            topLevelSwarm.activateIn (null);
            topLevelSwarm.go ();
            topLevelSwarm.drop ();
        
    }
}
