
#ifndef _JAVA_CLASS_H
#define _JAVA_CLASS_H

/*
 *  JavaClass:  encapsulate a java class; allow users to query method
 *  ids and call static methods on the class
 */

#include "jni.h"
#include <objc/Object.h>

@interface JavaClass : Object {
  JNIEnv * env;
  jclass clsid;
}

+ new:  (char *)class;

- init: (char *)class env: (id) _env;

// various flavors of constructor
- (jobject) construct: (int) a : (int) b;
- (jobject) construct;

// various flavors of static method invocation
- (jobject) callObjectStaticMethod: (jmethodID) mid;

- (JNIEnv *)getEnv;
- (jmethodID)findMethod: (char *)method signature: (char *) sig;
- (jmethodID)findStaticMethod: (char *)method signature: (char *) sig;

@end

#endif
