
import java.awt.*;
import java.awt.event.*;


class JavaJRaster extends Frame
  implements ActionListener,
  ComponentListener
{
  int color;
  int width, height;

  JavaJMemCanvas canvas;

  JavaJRaster(int w, int h) {
    super();

    System.out.println("JavaJraster init");
    width = w; height = h;
    color = 0;

    setSize(w, h);

    // give us a canvas to stretch over the whole thing
    canvas = new JavaJMemCanvas();
    add("Center", canvas);

    this.addComponentListener(this);

    setBackground(Color.black);
    setVisible(true);

    if (false) {
      addWindowListener(new JRWAdapter());
    }
  }

  class JRWAdapter extends WindowAdapter {
    public void windowClosing(WindowEvent event) {
      System.out.println("window close");
      dispose();
    }
  }

  public void erase() {
    System.out.println("erase");
    Graphics g = canvas.imageGraphics();
    g.setColor(Color.black);
    g.clearRect(0, 0, width, height);
    return;
  }

  public void drawPoint(int x, int y, int color) {
    System.out.println("point "+x+","+y);
    fillRectangle(x, y, x+1, y+1, color);
  }

  public void fillRectangle(int x0, int y0, int x1, int y1, int color) {
    Graphics g = canvas.imageGraphics();

    if (color != this.color) {
      this.color = color;
      color |= 0xff000000;
      g.setColor(new Color(color));
    }

    g.fillRect(x0, y0, x1-x0, y1-y0);
  }

  public void drawSelf() {
    repaint();
  }

  public void paint(Graphics g) {
    canvas.repaint();
    g.dispose();
  }

  public void componentResized(ComponentEvent e) {
    System.out.println("Mem: resized!!!");
    canvas.componentResized();
  }
  public void componentMoved(ComponentEvent e) {
    System.out.println("Mem: moved!!!");
  }
  public void componentShown(ComponentEvent e) {
    System.out.println("Mem: shown!!!");
  }
  public void componentHidden(ComponentEvent e) {
  }

  public void actionPerformed(ActionEvent event) {
    Object source = event.getSource();
    System.out.println("event!" + event);
  }

}
