
#import <swarmgraph/global.h>
#import <swarmgraph/JavaClass.h>
#import <swarmgraph/JavaMutex.h>

@implementation JavaMutex;

+ new {
  self = [JavaMutex alloc];

  // look up our class id
  id jMutexClass = [JavaClass new: "JavaJMutex"];

  // call the void constructor
  jobject mutexobj = [jMutexClass construct];

  // establish the JavaObject of this class backed by this real object
  [super init: jRasterClass : mutex];

  return self;
}

-free {
  [super free];
  return self;
}

// take the lock
-take {
  if (_take == 0)
    _take = [classid findMethod: "take" signature: "()V"];

  [self callVoidMethod: _take];
  return self;
}

// drop the lock
-drop {
  if (_drop == 0)
    _drop = [classid findMethod: "drop" signature: "()V"];

  [self callVoidMethod: _drop];
  return self;
}

@end
