#import "ObserverSwarm.h"
#import "ModelSwarm.h"
#import <collections.h>
#import <swarmobject.h>

@implementation ObserverSwarm

// createBegin: here we set up the default observation parameters.
+createBegin: (id) aZone {
  ObserverSwarm * obj;
  ProbeMap * probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "ringDistribute"
			     inClass: [self class]]
			setHideResult: 1]];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "boingDistribute"
			     inClass: [self class]]
			setHideResult: 1]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-createEnd {
  return [super createEnd];
}

-buildObjects {
  id modelZone;	

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];
  modelSwarm = [ModelSwarm create: modelZone];
  
  // Now create probe objects on the model and ourselves. This gives a
  // simple user interface to let the user change parameters.
  [probeDisplayManager createProbeDisplayFor: modelSwarm];
  [probeDisplayManager createProbeDisplayFor: self];


  [controlPanel waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  graphCanvas = [Canvas create: [self getZone]] ;
  [[graphCanvas setHeight: 500] setWidth: 500] ;
  [graphCanvas setWindowTitle: "Dynamic Graph"] ;
  [globalTkInterp eval: 
    "pack %s -expand 1 -fill both ; update idletasks", 
    [graphCanvas getWidgetName]] ;
 
  [modelSwarm setGraphCanvas: graphCanvas] ;
  [modelSwarm buildObjects];

  return self ;
}  

-ringDistribute {
  [[modelSwarm getTheNet] redistribute] ;
  return self ;
}

-boingDistribute {
  [[modelSwarm getTheNet] boingDistribute] ;
  return self ;
}

-buildActions {
  [super buildActions];
  
  [modelSwarm buildActions];
  
  displayActions = [ActionGroup create: [self getZone]];

  [displayActions createActionTo: [modelSwarm getTheNet] message: M(boingStep)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: controlPanel        message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

-activateIn: (id) swarmContext {

  [super activateIn: swarmContext];

  [modelSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

@end








