// Market application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "global.h"
#import "extern.h"
#import "MarketObserverSwarm.h"

static char *predictorColors[] = {
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black"
};
static unsigned numPredictorsToShow = 7;

// implementation of sample graphical interface for models.
@implementation MarketObserverSwarm

+createBegin: (id) aZone {
  MarketObserverSwarm * obj;
  ProbeMap * probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-buildObjects {
  id modelZone;

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];
  marketModelSwarm = [MarketModelSwarm create: modelZone];
  
  [probeDisplayManager createProbeDisplayFor: marketModelSwarm];
  [probeDisplayManager createProbeDisplayFor: self];

#ifdef oldway
  [controlPanel waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;
#else
  [controlPanel setStateStopped];
#endif

  [marketModelSwarm buildObjects];

  // turn off stdio printing.
  pr_text = 0;
  
  // create graph for price of commodity
  priceGraph = [BLTGraph create: globalZone];
  [priceGraph title: "Price of commodity vs. time"];
  [priceGraph axisLabelsX: "time" Y: "price"];
  [priceGraph setWidth: 400 Height: 250];
  [priceGraph pack];
  [priceGraph setScaleModeX: 1 Y: 0];

  // create three elements to draw on that graph.
  priceElement = [priceGraph createElement];
  [[[priceElement setLabel: "price"] setColor: "red"] setWidth: 3];
  priceGrapher = [ActiveGraph createBegin: [self getZone]];
  [priceGrapher setElement: priceElement];
  [priceGrapher setDataFeed: marketModelSwarm];
  [priceGrapher setProbedSelector: M(getPrice)];
  priceGrapher = [priceGrapher createEnd];

  dividendElement = [priceGraph createElement];
  [[dividendElement setLabel: "dividend"] setColor: "black"];
  dividendGrapher = [ActiveGraph createBegin: [self getZone]];
  [dividendGrapher setElement: dividendElement];
  [dividendGrapher setDataFeed: marketModelSwarm];
  [dividendGrapher setProbedSelector: M(getDividend)];
  dividendGrapher = [dividendGrapher createEnd];

  fundamentalElement = [priceGraph createElement];
  [[fundamentalElement setLabel: "fundamental"] setColor: "blue"];
  fundamentalGrapher = [ActiveGraph createBegin: [self getZone]];
  [fundamentalGrapher setElement: fundamentalElement];
  [fundamentalGrapher setDataFeed: marketModelSwarm];
  [fundamentalGrapher setProbedSelector: M(getFundamental)];
  fundamentalGrapher = [fundamentalGrapher createEnd];
  
  useHisto = [Histo create: globalZone];
  [useHisto setWidth: 400 Height: 250];
  [useHisto setNumPoints: numPredictorsToShow
	    Labels: pred
	    Colors: predictorColors];
  [useHisto title: "Usage of predictors"];
  [useHisto axisLabelsX: "predictor index" Y: "usage of predictor"];
  [useHisto pack];
  
  return self;
}  

-buildActions {
  [super buildActions];
  
  [marketModelSwarm buildActions];

  displayActions = [ActionGroup create: [self getZone]];
  [displayActions createActionTo: priceGrapher        message: M(step)];
  [displayActions createActionTo: dividendGrapher     message: M(step)];
  [displayActions createActionTo: fundamentalGrapher  message: M(step)];
  [displayActions createActionTo: self                message: M(updateHisto)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
#ifdef _TK_
  [displayActions createActionTo: controlPanel        message: M(doTkEvents)];
#else
  [displayActions createActionTo: controlPanel        message: M(checkState)];
#endif

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [marketModelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}

-updateHisto {
fprintf(stderr, "updating histo...\n");
  [useHisto drawHistoWithInt: [marketModelSwarm getPredictorUse]];
  return self;
}

@end
