//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            ACGgen.h
Description:     Additive Congruential Generator
Library:         random
Original Author: Nelson Minar
Date:            1996-09-09
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/

// This generator returns successive pseudo-random UNSIGNED INTEGERS
// in the closed interval [0, 2^32-1]:

// ACG is an often used algorithm, mentioned in Knut, Numerical Recipes, etc.
// It is in the Lagged Fibonacci class of generators.

// These values recommended by Knuth.

#define ACGLONGLAG  55
#define ACGSHORTLAG 24

#import <random/RandomNumberGenerator.h>


@interface ACG: RandomNumberGenerator

{

// Parameters:

   unsigned s;		// short lag
   unsigned r;		// long lag (=size of state vector)

// Data objects (state variables):

   unsigned index;		// pointer to current value
   unsigned state[ACGLONGLAG];	// vector of lagged values (state vector)

}

// The following RandomNumberGenerator methods are overridden:

// -initState;
// -resetState;

// -(void) getState: (void *) stateBuf;
// -(void) setState: (void *) stateBuf;

// -(unsigned) getUnsignedSample;
- (void) describe: outStream;
-(int) verifySelf;

@end
