//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            UniformUnsigned.h
Description:     Uniform distribution returning unsigned integer values
Library:         random
Original Author: Nelson Minar
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/


#import <random/RandomDefs.h>
#import <random/ProbabilityDistribution.h>

@interface UniformUnsigned: ProbabilityDistribution //<UniformUnsigned>

{

// Parameters:

   unsigned uMin;
   unsigned uMax;
   unsigned uRange;
   unsigned uCutoff;

// Working variables:


}

// Methods that conform to the UniformDouble protocol:

+create: aZone setGenerator: generator
	setUnsignedMin: (unsigned) minValue setMax: (unsigned) maxValue;

-(void) setUnsignedMin: (unsigned) minValue setMax: (unsigned) maxValue;

-(unsigned) getUnsignedMin;
-(unsigned) getUnsignedMax;

-(unsigned) getUnsignedWithMin: (unsigned) minValue 
			withMax: (unsigned) maxValue;

// Methods that conform to the DoubleDistribution protocol:

-(unsigned) getUnsignedSample;

// Methods that override superclass methods:

// -(void) getState: (void *) state;
// -(void) setState: (void *) state;

// -initState;
// -resetState;

// temporary methods:

-(unsigned) getAlternateUnsignedSample;

@end
