// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Objective C interface to BltGraph, for use with libtclobjc

#ifdef _TK_
#else
#include <jni.h>
#include <swarmgraph/JavaGraph.h>
#endif

#import <swarmgraph/Widget.h>

@class GraphElement;
@class BLTVector;

@interface BLTGraph : Widget {
  id elementList;
#ifndef _TK_
  JavaGraph  * jGraph;
#endif
}

-(GraphElement *) createElement;		  // create a dataset to draw
-destroyElement: (GraphElement *) g;		  // remove element, free it.
-title: (char *) t;				  // title the graph
-axisLabelsX: (char *) xl Y: (char *) yl;	  // change labels here.
-setScaleModeX: (int) xs Y: (int) ys;		  // 0 smooth, 1 jump
-setRangesXMin: (double) minX Max: (double) maxX YMin: (double) minY Max: (double) maxY;        // bltgraph will autoscale, but you can also fix scale.
#ifndef _TK_
-createJavaElement: (char *)name;
-addElem: (char *) name X: (double)x Y: (double)y;
-setElem: (char *)name Len: (int)n;
-dropElem: (char *)name;
-setColor: (char *)n Color: (char *) color;
-update;
#endif
@end

// object to describe one element (dataset) in a graph.
@interface GraphElement : CreateDrop {
  char * name;
  BLTGraph * ownerGraph;
  BLTVector *xData, *yData;
}

-setOwnerGraph: (BLTGraph *) og;
-createEnd;
+createOwnerGraph: (BLTGraph *) og;		  // alternate creation.

-(char *)getName;
-(BLTVector *) getXData;
-(BLTVector *) getYData;

-addX: (double) x Y: (double) y;
-resetData;

// user configurable options.
-setLabel: (char *) label;
-setColor: (char *) color;
-setWidth: (unsigned) w;
-setSymbol: (char *)s;   // line square circle diamond plus cross splus scross
-setDashes: (int) i;				  // only if we're a line.
@end

// wrapper for BLT 2.x vectors, most important functions..
@interface BLTVector : CreateDrop {
  char * name;
#ifndef _TK_
  JavaGraph	 * jgraph;	// java graph object
  double 	 * val;		// shadow data vector
  unsigned	 max_val;	// maximum possible values in "val" 
  unsigned	 cur_val;	// number of valid values in "val"
#define	BLTV_CHUNK	1010
#endif
}

-createEnd;
-(char *)getName;
-(unsigned) getLength;

-setLength: (unsigned) n;
-append: (double) v;
-resetData;
-delete: (int) n;
@end
