// Swarm library. Copyright (C) 1996-1997 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Control Panel class, for use in GUIs. Controls the state of running
// activities, provides the "stop" and "go" buttons. Also handles updating
// the Tk event loop.

#import <swarmobject/SwarmObject.h>
#import <swarmgraph.h>

// these tokens are the various states of the ControlPanel. "getState"
// returns one of these four values.
extern id ControlStateRunning, ControlStateStopped;
extern id ControlStateStepping, ControlStateNextTime, ControlStateQuit;

@interface ControlPanel : SwarmObject {
  id state;			 // uses activity.h symbols
#ifndef _TK_
  id ctlObj;			// the proxy to the java control panel
#endif
}

#ifndef _TK_
-checkState;
#endif
-setCtlObj: (id)ctl;
-(id) getState;
- setState: (id) s;

-createEnd;
-waitForControlEvent; // deprecated, use this message on ActionCache

-startInActivity: (id) activityID;
-setStateRunning;
-setStateStopped;
-setStateStoppedAndSave;
-setStateStepping;
-setStateQuit;
-setStateNextTime;

#ifdef _TK_
// Deprecated Methods
-doTkEvents;  // deprecated, use this message on ActionCache
-(id) getPanel;  // deprecated, use this on ActionCache
#endif
@end
