
#ifndef _JAVA_CONTROL_H
#define _JAVA_CONTROL_H
#include "JavaObject.h"

typedef enum {
 ControlStateRunning = 0, 
 ControlStateStopped,
 ControlStateStepping, 
 ControlStateNextTime, 
 ControlStateQuit
} CtlState;


@interface JavaControl : JavaObject {
  jmethodID _getState;
  jmethodID _setState;
  jmethodID _waitRun;
}

+ new: (id) _classid;

- init: (id) _classid;

//  set the control panel into a new state
- (int) getState;
//  query the control panel state
- (void) setState: (int)state;

// wait for the control panel to signal non-stopped state
- (void) waitRun;

@end

#endif
