
#include "JavaEnv.h"
#include "JavaObject.h"

@implementation JavaObject;

+ new: (id) _classid : (jobject) _this {

  self = [JavaObject alloc];
  return [self init: _classid : _this];
}

- init: (id)_classid : (jobject) _this {
  fprintf(stderr, "JavaObject init\n");
  [super init];
  classid = _classid;
  fprintf(stderr, "JavaObject init getenv\n");
  env = [classid getEnv];
  this = _this;
  fprintf(stderr, "JavaObject init return\n");

  return self;
}

- (jint) callIntMethod: (jmethodID) id {
  return (*env)->CallIntMethod(env, this, id);
}

- (void) callVoidMethod: (jmethodID) id {
  // fprintf(stderr, "call void method 0\n");
  return (*env)->CallVoidMethod(env, this, id);
}

- (void) callVoidMethod: (jmethodID) id : (int)val1 {
  // fprintf(stderr, "call void method 1, arg=%d\n", val1);
  return (*env)->CallVoidMethod(env, this, id, (jint)val1);
}

- (void) callVoidMethod: (jmethodID) id : (int)val1 : (int)val2 {
  fprintf(stderr, "call void method 2, arg=%d,%d\n", val1,val2);
  return (*env)->CallVoidMethod(env, this, id, 
				(jint)val1, 
				(jint)val2);
}

- (void) callVoidMethod: (jmethodID) id : (int)val1 : (int)val2 
		       : (int)val3 {
  fprintf(stderr, "call void method 3, arg=%d,%d,%d\n", val1,val2,val3);
  return (*env)->CallVoidMethod(env, this, id, 
				(jint)val1, 
				(jint)val2, 
				(jint)val3);
}

- (void) callVoidMethod: (jmethodID) id : (int)val1 : (int)val2 
		       : (int)val3 : (int)val4 
{
  /* fprintf(stderr, "call void method 4, arg=%d,%d,%d,%d\n", 
                     val1,val2,val3,val4); */
  return (*env)->CallVoidMethod(env, this, id, 
				(jint)val1, 
				(jint)val2, 
				(jint)val3, 
				(jint)val4);
}

- (void) callVoidMethod: (jmethodID) id : (int)val1 : (int)val2 
		       : (int)val3 : (int)val4 : (int)val5
{
  /* fprintf(stderr, "call void method 5, arg=%d,%d,%d,%d,%d\n", 
     val1, val2, val3, val4, val5); */
  return (*env)->CallVoidMethod(env, this, id, 
				(jint)val1, 
				(jint)val2, 
				(jint)val3, 
				(jint)val4, 
				(jint)val5);
}


- (void) callVoidMethod: (jmethodID) id D: (double)val1 D: (double)val2 {
  return (*env)->CallVoidMethod(env, this, id, 
				(jdouble)val1, 
				(jdouble)val2);
}

- (void) callVoidMethod: (jmethodID) id D: (double)val1 D: (double)val2
		       D: (double)val3 D: (double)val4 {
  (*env)->CallVoidMethod(env, this, id, (jdouble)val1, 
			 (jdouble)val2, (jdouble)val3, (jdouble)val4);
}

- (void) callVoidMethod: (jmethodID) id S: (char *)val1 {
  jstring str1 = (*env)->NewStringUTF(env, val1);

  (*env)->CallVoidMethod(env, this, id, str1);

  (*env)->DeleteLocalRef(env, str1);
}

- (void) callVoidMethod: (jmethodID) id S: (char *)val1 S: (char *)val2 {
  jstring str1 = (*env)->NewStringUTF(env, val1);
  jstring str2 = (*env)->NewStringUTF(env, val2);

  (*env)->CallVoidMethod(env, this, id, 
			 str1, str2);

  (*env)->DeleteLocalRef(env, str1);
  (*env)->DeleteLocalRef(env, str2);
}

- (void) callVoidMethod: (jmethodID) id S: (char *)val1 I: (int)val2 {
  jstring str1 = (*env)->NewStringUTF(env, val1);

  return (*env)->CallVoidMethod(env, this, id, 
				str1,
				(jint)val2);

  (*env)->DeleteLocalRef(env, str1);
}

- (void) callVoidMethod: (jmethodID) id S: (char *)val1 
		      D: (double)val2 D: (double)val3 {
  jstring str1 = (*env)->NewStringUTF(env, val1);

  (*env)->CallVoidMethod(env, this, id, 
			 str1, (jdouble)val2, (jdouble)val3);

  (*env)->DeleteLocalRef(env, str1);
}


@end

