// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#define __USE_FIXED_PROTOTYPES__  // for gcc headers

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#import <swarmgraph/global.h>
#import <swarmgraph/Canvas.h>
#ifndef _TK_
#import <swarmgraph/JavaCanvas.h>
#endif

@implementation Canvas

-createEnd {
  [super createEnd];
#ifdef _TK_
  [globalTkInterp eval: "canvas %s", widgetName];
#else
  jCanvas = [[[JavaCanvas create: [self getZone]] initW: 400 H: 247] createEnd];
  // make the window we just created respond to the window events this
  // object is given
  [self initPeer: jCanvas];
#endif
  return self;
}

#ifndef _TK_

// the tk world places objects within a container using calls to the
// interpreter, passing the name of the object's widget.  we pass through
// a more formal path from objective C into a java placeholder object...

- placeObj: (id)obj X: (int)x Y: (int)y {
  return [jCanvas placeObj: obj X: x Y: y];
}

- moveObj: (id)obj X: (int)x Y: (int)y {
  return [jCanvas moveObj: obj X: x Y: y];
}

- drawLineFX: (int)fx FY: (int)fy TX: (int)tx TY: (int)ty {
  return [jCanvas drawLineFX: fx FY: fy TX: tx TY: ty];
}

- setColor: (char *)color {
  return [jCanvas setColor: color];
}

#endif

@end

