
#import <swarmgraph/global.h>

#include "JavaClass.h"
#include "JavaCanvas.h"

// JavaCanvas is an objective C class that provides the abstraction
// of a container that can hold other objects and be drawn upon

// "Canvas" comes from the tk/tcl meaning of canvas.  in the tk/tcl
// context, you can create new objects and move them by name around
// on a canvas.  you can also draw upon the canvas.  as a containter,
// (with a menu bar and border), the canvas is closer to a java frame, so 
// this class fronts an extension of the java frame that allows precise
// placment of other objects on its surface.

@implementation JavaCanvas;

- initW: (int)w H: (int)h {

  // look up our class id
  id jFrameClass = [JavaClass new: "JavaJFrame"];

  // call the constructor that takes width, height
  jobject frameobj = [jFrameClass construct: w : h];

  // establish the JavaObject of this class backed by this real object
  [super init: jFrameClass : frameobj];

  _placeObj = 0;
  _moveObj = 0;

  return self;
}

// put a given object onto this frame
- placeObj: (id)item X: (int)x Y: (int) y {

  jobject component = [item getObj];

  if (_placeObj == 0)
    _placeObj = [classid findMethod: "placeObj" signature: "(Ljava/awt/Component;II)V"];

  [self callVoidMethod: _placeObj O: component : x : y];
  return self;

}

// put a given object onto this frame
- moveObj: (id)item X: (int)x Y: (int) y {

  jobject component = [item getObj];

  if (_moveObj == 0)
    _moveObj = [classid findMethod: "moveObj" signature: "(Ljava/awt/Component;II)V"];

  [self callVoidMethod: _moveObj O: component : x : y];
  return self;
}

#if 0
- drawOvalX: (int)x Y: (int)y {
  jmethodID _do = [classid findMethod: "drawOval" signature: "(II)V"];
  [self callVoidMethod: _do : x : y];
  return self;
}
#endif

- drawLineFX: (int)fx FY: (int)fy TX: (int)tx TY: (int)ty {
  if (_drawLine == 0)
    _drawLine = [classid findMethod: "drawLine" signature: "(IIII)V"];
  [self callVoidMethod: _drawLine : fx : fy : tx : ty];
  return self;
}

- setColor: (char *)color {
  if (_setColor == 0) {
    _setColor = [classid findMethod: "setColor" 
			 signature: "(Ljava/lang/String;)V"];
  }
  [self callVoidMethod: _setColor S: color];
  return self;
}


@end
