
#ifndef _JAVA_CONTROL_H
#define _JAVA_CONTROL_H

#import <swarmgraph/JavaObject.h>

typedef enum {
 JControlStateRunning = 0, 
 JControlStateStopped,
 JControlStateStepping, 
 JControlStateNextTime, 
 JControlStateQuit
} CtlState;

@interface JavaControl : JavaObject {
  jmethodID _getState;
  jmethodID _setState;
  jmethodID _waitRun;
  jmethodID _addAction;
}

- init;

// tell the control panel what actioncache to direct its signals to
- setActionCache: (id) actionCache;
- addAction:  (char *) actName : (id)actId;

//  set the control panel into a new state
- getState;
//  query the control panel state
- setState: (id)state;

// wait for the control panel to signal non-stopped state
- (void) waitRun;

@end

#endif
