
#include "JavaEnv.h"

extern char * getenv(const char *);
extern char * strcat(char *, const char *);

id javaEnv = 0;

// XXX define "PC" in makefile.conf
#ifdef PC
#define SEPSTR ";"
#else
#define SEPSTR	":"
#endif

@implementation JavaEnv

+ new {
  self = [JavaEnv alloc];
  fprintf(stderr, "creating... java env\n");
  [self init];
  return self;
}


- init {
    jint res;
    char classpath[4096];
    char * env_var;

    JNI_GetDefaultJavaVMInitArgs(&vm_args);
    fprintf(stderr, "initializing; classpath=%s\n", vm_args.classpath);
    fprintf(stderr, "initializing; version=%x\n", vm_args.version);

    // our classes are found in $(SWARMHOME)/lib
    sprintf(classpath, ".%s", SEPSTR);
    if ((env_var = getenv("SWARMHOME")) != NULL)
      {
	strcat(classpath, env_var);
	strcat(classpath, "/lib");
	strcat(classpath, SEPSTR);
      }
    // if we have a classpath environment, tack it on
    if ((env_var = getenv("CLASSPATH")) != NULL)
      {
	strcat(classpath, env_var);
	strcat(classpath, SEPSTR);
      }
    // add the rest of the classpath
    strcat(classpath, vm_args.classpath);
    vm_args.classpath = classpath;

    res = JNI_CreateJavaVM(&jvm,&env,&vm_args);
    if (res < 0) {
        fprintf(stderr, "Can't create Java VM\n");
        exit(1);
    }

    return self;
}

- (void) free {
  (*jvm)->DestroyJavaVM(jvm);
  [super free];
}

- (JNIEnv *)getEnv {
  return env;
}

- (jclass)findClass: (char *)class {
  jclass cls = (*env)->FindClass(env, class);
  if (cls == 0) {
    fprintf(stderr, "Can't find class %s\n", class);
    exit(1);
  }

  return cls;
}



@end

