
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;


class JavaJItem extends Panel
  implements MouseListener
{
  int _type;
  int _color;
  int _width, _height;

  private static final int OVAL = 0;
  private static final int RECT = 1;

  JavaJItem(int type, int color, int w, int h) {
    System.out.println("JavaJItem.Java init");

    _type = type;
    _color = 0;
    _width = w; _height = h;

    addMouseListener(this);
    setVisible(true);
  }

  public Dimension preferredSize() {
    return new Dimension(_width+1, _height+1);
  }

  public Dimension minimumSize() {
    return new Dimension(_width+1, _height+1);
  }

  public void setColor(int color) {
    if (color != _color) {
      _color = color;
      _color |= 0xff000000;
    }
  }

  public void erase() {
    Graphics g = getGraphics();

    g.setXORMode(new Color(_color));
    paintObj(g);
    g.setPaintMode();

    g.dispose();
    return;
  }

  public void paintObj(Graphics g) {
    g.setColor(Color.black);

    switch (_type) {
    case OVAL:
      g.drawOval(0, 0, _width, _height);
      break;
    case RECT:
      g.drawRect(0, 0, _width, _height);
      break;
    }
  }

  public void update(Graphics g) {
    paint(g);
  }

  public void paint(Graphics g) {
    if (false) {
    Rectangle r = bounds();

    // pull the image underlying your parent, or we'll write out a block
    // of white
    JavaJFrame jf = ((JavaJFrame)getParent());

    CropImageFilter cropf = new CropImageFilter(r.x, r.y, r.width, r.height);
    Image jfi = jf.bgImage();
    ImageProducer ip = new FilteredImageSource(jfi.getSource(), cropf);
    Image img = getToolkit().createImage(ip);

    // wait until it's loaded or we'll get crap
    waitImage(img);
    g.drawImage(img, 0, 0, null);
    }

    paintObj(g);
  }

  public void waitImage(Image img) {
    try {
      MediaTracker t = new MediaTracker(this);
      t.addImage(img, 0);
      t.waitForAll();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public void mouseClicked(MouseEvent event) {
    Object source = event.getSource();
    System.out.println("event!" + event);
  }
  public void mouseEntered(MouseEvent event) {
  }
  public void mouseExited(MouseEvent event) {
    Object source = event.getSource();
    System.out.println("event!" + event);
  }
  public void mousePressed(MouseEvent event) {
  }
  public void mouseReleased(MouseEvent event) {
  }

}
