
#ifndef _JAVA_OBJECT_H
#define _JAVA_OBJECT_H
/*
 *  JavaObject:  encapsulate some random java object and provide some
 *  simple, common access to methods on that object
 */

#import <defobj.h>
#import <defobj/Create.h>
#include "JavaClass.h"

@interface JavaObject : CreateDrop {
  JNIEnv * env;
  id classid;		/* this object's class */ 
  jobject this;		/* this object */
}

- init: (id) _classid : (jobject) _this;
- createEnd;
-initPeer: (id)peer;

-(jobject) getObj;
-(id) getClass;

- (jint) callIntMethod: (jmethodID) id;

- (void) callVoidMethod: (jmethodID) id S: (char *)val1;
- (void) callVoidMethod: (jmethodID) id S: (char *)val1 S: (char *)val2;
- (void) callVoidMethod: (jmethodID) id S: (char *)val1 I: (int)val2;
- (void) callVoidMethod: (jmethodID) id S: (char *)val1 
		      D: (double)val2 D: (double)val3;
- (void) callVoidMethod: (jmethodID) id S: (char *)val1 S: (char *)val2 
		      D: (double)val3;

- (void) callVoidMethod: (jmethodID) id;
- (void) callVoidMethod: (jmethodID) id : (int)val1;
- (void) callVoidMethod: (jmethodID) id : (int)val1 : (int)val2;
- (void) callVoidMethod: (jmethodID) id : (int)val1 
		       : (int)val2 : (int)val3;
- (void) callVoidMethod: (jmethodID) id : (int)val1 
		       : (int)val2 : (int)val3 : (int)val4;
- (void) callVoidMethod: (jmethodID) id : (int)val1 
		       : (int)val2 : (int)val3 : (int)val4 
		       : (int)val5;


- (void) callVoidMethod: (jmethodID) id O: (jobject)val1 
		       : (int)val2 : (int)val3;

- (void) callVoidMethod: (jmethodID) id D: (double)val1 D: (double)val2;
- (void) callVoidMethod: (jmethodID) id D: (double)val1 D: (double)val2
		       D: (double)val3 D: (double)val4;

- (jobject) callObjectMethod: (jmethodID) id;

@end

#endif

