extern int EE();

#include <jni.h>
#include <objc/objc.h>
#include "JavaEnv.h"
#include "JavaClass.h"
#include "MainControl.h"

typedef enum {
  STOP = 0,
  RUN = 1,
  STEP = 2
} RunType;


main() {
  /* initialize the Java environment */
  id env = [JavaEnv new];

  /* make us a java object of class "CtlPanel" and use it to initialize
     an objective C object called MainControl that represents our 
     gui control */
  id ctlObj = [MainControl new: [JavaClass new: "CtlPanel" env: env]];

  while (1) {
    int state;

    /* see if we're in run/stop/step state */
    state = [ctlObj getState];

    if (state == STEP) {
      /* do one step and stop until we get another step or run */
      [ctlObj setState: STOP];
    } else if (state == STOP) {
      /* if we're in STOP state, block until the gui says it's ok
	 to continue */
      [ctlObj waitRun];
    }

    fprintf(stderr, "tic\n");
    /* sleep(1); */
  }

  [env free];
}





