/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.ConstantValueAttr;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.Field;
import gnu.bytecode.InnerClassesAttr;
import gnu.bytecode.LineNumbersAttr;
import gnu.bytecode.LocalVarsAttr;
import gnu.bytecode.Method;
import gnu.bytecode.MiscAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.Variable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ClassFileInput
extends DataInputStream {
    ClassType ctype;
    InputStream str;

    public ClassFileInput(ClassType ctype, InputStream str) throws IOException, ClassFormatError {
        super(str);
        this.ctype = ctype;
        if (!this.readHeader()) {
            throw new ClassFormatError("invalid magic number");
        }
        ctype.constants = this.readConstants();
        this.readClassInfo();
        this.readFields();
        this.readMethods();
        this.readAttributes(ctype);
    }

    public ClassFileInput(InputStream str) throws IOException {
        super(str);
    }

    public Attribute readAttribute(String name, int length, AttrContainer container) throws IOException {
        if (name == "SourceFile" && container instanceof ClassType) {
            return new SourceFileAttr(this.readUnsignedShort(), (ClassType)container);
        }
        if (name == "Code" && container instanceof Method) {
            CodeAttr code = new CodeAttr((Method)container);
            code.setMaxStack(this.readUnsignedShort());
            code.setMaxLocals(this.readUnsignedShort());
            int code_len = this.readInt();
            byte[] insns = new byte[code_len];
            this.readFully(insns);
            code.setCode(insns);
            int exception_table_length = this.readUnsignedShort();
            int i = 0;
            while (i < exception_table_length) {
                int start_pc = this.readUnsignedShort();
                int end_pc = this.readUnsignedShort();
                int handler_pc = this.readUnsignedShort();
                int catch_type = this.readUnsignedShort();
                code.addHandler(start_pc, end_pc, handler_pc, catch_type);
                ++i;
            }
            this.readAttributes(code);
            return code;
        }
        if (name == "LineNumberTable" && container instanceof CodeAttr) {
            int count = 2 * this.readUnsignedShort();
            short[] numbers2 = new short[count];
            int i = 0;
            while (i < count) {
                numbers2[i] = this.readShort();
                ++i;
            }
            return new LineNumbersAttr(numbers2, (CodeAttr)container);
        }
        if (name == "LocalVariableTable" && container instanceof CodeAttr) {
            LocalVarsAttr attr = new LocalVarsAttr((CodeAttr)container);
            Method method = attr.getMethod();
            if (attr.parameter_scope == null) {
                attr.parameter_scope = method.pushScope();
            }
            Scope scope = attr.parameter_scope;
            ConstantPool constants = method.getConstants();
            int count = this.readUnsignedShort();
            int i = 0;
            while (i < count) {
                Variable var = new Variable();
                scope.addVariable(var);
                var.start_pc = this.readUnsignedShort();
                var.end_pc = var.start_pc + this.readUnsignedShort();
                var.setName(this.readUnsignedShort(), constants);
                var.setSignature(this.readUnsignedShort(), constants);
                var.offset = this.readUnsignedShort();
                ++i;
            }
            return attr;
        }
        if (name == "ConstantValue" && container instanceof Field) {
            return new ConstantValueAttr(this.readUnsignedShort());
        }
        if (name == "InnerClasses" && container instanceof ClassType) {
            int count = 4 * this.readUnsignedShort();
            short[] data = new short[count];
            int i = 0;
            while (i < count) {
                data[i] = this.readShort();
                ++i;
            }
            return new InnerClassesAttr(data, (ClassType)container);
        }
        if (name == "Exceptions" && container instanceof Method) {
            Method meth = (Method)container;
            int count = this.readUnsignedShort();
            short[] exn_indices = new short[count];
            int i = 0;
            while (i < count) {
                exn_indices[i] = this.readShort();
                ++i;
            }
            meth.setExceptions(exn_indices);
            return meth.getExceptionAttr();
        }
        byte[] data = new byte[length];
        this.readFully(data, 0, length);
        return new MiscAttr(name, data);
    }

    public int readAttributes(AttrContainer container) throws IOException {
        int count = this.readUnsignedShort();
        Attribute last = container.getAttributes();
        int i = 0;
        while (i < count) {
            if (last != null) {
                Attribute next;
                while ((next = last.getNext()) != null) {
                    last = next;
                }
            }
            int index = this.readUnsignedShort();
            CpoolUtf8 nameConstant = (CpoolUtf8)this.ctype.constants.getForced(index, 1);
            int length = this.readInt();
            nameConstant.intern();
            Attribute attr = this.readAttribute(nameConstant.string, length, container);
            if (attr != null) {
                if (attr.getNameIndex() == 0) {
                    attr.setNameIndex(index);
                }
                if (last == null) {
                    container.setAttributes(attr);
                } else {
                    if (container.getAttributes() == attr) {
                        container.setAttributes(attr.getNext());
                        attr.setNext(null);
                    }
                    last.setNext(attr);
                }
                last = attr;
            }
            ++i;
        }
        return count;
    }

    public void readClassInfo() throws IOException {
        this.ctype.access_flags = this.readUnsignedShort();
        this.ctype.thisClassIndex = this.readUnsignedShort();
        CpoolClass clas = (CpoolClass)this.ctype.constants.getForced(this.ctype.thisClassIndex, 7);
        String name = clas.name.string;
        this.ctype.this_name = name.replace('/', '.');
        this.ctype.setSignature("L" + name + ";");
        this.ctype.superClassIndex = this.readUnsignedShort();
        if (this.ctype.superClassIndex == 0) {
            this.ctype.setSuper((ClassType)null);
        } else {
            clas = (CpoolClass)this.ctype.constants.getForced(this.ctype.superClassIndex, 7);
            name = clas.name.string;
            this.ctype.setSuper(name.replace('/', '.'));
        }
        int nInterfaces = this.readUnsignedShort();
        if (nInterfaces > 0) {
            this.ctype.interfaces = new ClassType[nInterfaces];
            this.ctype.interfaceIndexes = new int[nInterfaces];
            int i = 0;
            while (i < nInterfaces) {
                int index;
                this.ctype.interfaceIndexes[i] = index = this.readUnsignedShort();
                clas = (CpoolClass)this.ctype.constants.getForced(index, 7);
                name = clas.name.string.replace('/', '.');
                this.ctype.interfaces[i] = ClassType.make(name);
                ++i;
            }
        }
    }

    public static ClassType readClassType(InputStream str) throws IOException, ClassFormatError {
        ClassType ctype = new ClassType();
        ClassFileInput reader = new ClassFileInput(ctype, str);
        return ctype;
    }

    public ConstantPool readConstants() throws IOException {
        return new ConstantPool(this);
    }

    public void readFields() throws IOException {
        int nFields = this.readUnsignedShort();
        ConstantPool constants = this.ctype.constants;
        int i = 0;
        while (i < nFields) {
            int flags = this.readUnsignedShort();
            int nameIndex = this.readUnsignedShort();
            int descriptorIndex = this.readUnsignedShort();
            Field fld = this.ctype.addField();
            fld.setName(nameIndex, constants);
            fld.setSignature(descriptorIndex, constants);
            fld.flags = flags;
            this.readAttributes(fld);
            ++i;
        }
    }

    public boolean readHeader() throws IOException {
        int magic = this.readInt();
        if (magic != -889275714) {
            return false;
        }
        short minor_version = this.readShort();
        short major_version = this.readShort();
        return true;
    }

    public void readMethods() throws IOException {
        int nMethods = this.readUnsignedShort();
        ConstantPool constants = this.ctype.constants;
        int i = 0;
        while (i < nMethods) {
            int flags = this.readUnsignedShort();
            int nameIndex = this.readUnsignedShort();
            int descriptorIndex = this.readUnsignedShort();
            Method meth = this.ctype.addMethod(null, flags);
            meth.setName(nameIndex);
            meth.setSignature(descriptorIndex);
            this.readAttributes(meth);
            ++i;
        }
    }

    public final void skipAttribute(int length) throws IOException {
        int read2 = 0;
        while (read2 < length) {
            int skipped = (int)this.skip(length - read2);
            if (skipped == 0) {
                if (this.read() < 0) {
                    throw new EOFException("EOF while reading class files attributes");
                }
                skipped = 1;
            }
            read2 += skipped;
        }
    }
}

