/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import kawa.TelnetInputStream;
import kawa.TelnetOutputStream;

public class Telnet
implements Runnable {
    boolean isServer;
    static final int SE = 240;
    static final int NOP = 241;
    static final int IP = 244;
    static final int EOF = 236;
    static final int SB = 250;
    public static final int WILL = 251;
    public static final int WONT = 252;
    public static final int DO = 253;
    public static final int DONT = 254;
    static final int IAC = 255;
    public static final int ECHO = 1;
    public static final int SUPPRESS_GO_AHEAD = 3;
    static final int TM = 6;
    static final int TTYPE = 24;
    static final int NAWS = 31;
    static final int LINEMODE = 34;
    public short windowHeight;
    public short windowWidth;
    public byte[] terminalType;
    final byte preferredLineMode = (byte)3;
    InputStream sin;
    OutputStream sout;
    TelnetInputStream in;
    TelnetOutputStream out;
    final byte[] optionsState = new byte[256];
    static final int OPTION_NO = 0;
    static final int OPTION_WANTNO = 1;
    static final int OPTION_WANTNO_OPPOSITE = 2;
    static final int OPTION_WANTYES = 3;
    static final int OPTION_WANTYES_OPPOSITE = 4;
    static final int OPTION_YES = 5;

    public Telnet(Socket socket, boolean bl) throws IOException {
        this.sin = socket.getInputStream();
        this.sout = socket.getOutputStream();
        this.out = new TelnetOutputStream(this.sout);
        this.in = new TelnetInputStream(this.sin, this);
        this.isServer = bl;
    }

    boolean change(int n, int n2) {
        if (n2 == 6) {
            return true;
        }
        if (this.isServer && n2 == 31) {
            return true;
        }
        if (this.isServer && n == 251 && n2 == 34) {
            byte[] byArray = new byte[]{1, 3};
            try {
                this.out.writeSubCommand(34, byArray);
            }
            catch (IOException iOException) {}
            return true;
        }
        if (this.isServer && n == 251 && n2 == 24) {
            byte[] byArray = new byte[]{1};
            try {
                this.out.writeSubCommand(n2, byArray);
            }
            catch (IOException iOException) {}
            return true;
        }
        if (!this.isServer && n2 == 1) {
            if (n == 253) {
                return false;
            }
            if (n == 251) {
                return true;
            }
        }
        return false;
    }

    public TelnetInputStream getInputStream() {
        return this.in;
    }

    public TelnetOutputStream getOutputStream() {
        return this.out;
    }

    void handle(int n, int n2) throws IOException {
        boolean bl = n < 253;
        boolean bl2 = (n & 1) != 0;
        int n3 = this.optionsState[n2];
        if (bl) {
            n3 = (byte)(n3 >> 3);
        }
        switch (n3 >> 3 & 7) {
            case 5: {
                if (bl2) {
                    return;
                }
                n3 = 0;
                this.change(n, n2);
                this.out.writeCommand(bl ? 254 : 252, n2);
                break;
            }
            case 0: {
                if (!bl2) {
                    return;
                }
                if (this.change(n, n2)) {
                    n3 = 5;
                    this.out.writeCommand(bl ? 253 : 251, n2);
                    break;
                }
                this.out.writeCommand(bl ? 254 : 252, n2);
                break;
            }
            case 1: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = 3;
                this.out.writeCommand(bl ? 253 : 251, n2);
                break;
            }
            case 3: {
                if (bl2) {
                    n3 = 5;
                    this.change(n, n2);
                    break;
                }
                n3 = 0;
                break;
            }
            case 4: {
                if (bl2) {
                    n3 = 1;
                    this.out.writeCommand(bl ? 254 : 252, n2);
                    break;
                }
                n3 = 0;
                break;
            }
        }
        n3 = bl ? (int)((byte)(this.optionsState[n2] & 0xC7 | n3 << 3)) : (int)((byte)(this.optionsState[n2] & 0xF8 | n3));
        this.optionsState[n2] = n3;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Telnet.usage();
        }
        String string = stringArray[0];
        int n = 23;
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        try {
            int n2;
            Socket socket = new Socket(string, n);
            Telnet telnet = new Telnet(socket, false);
            TelnetOutputStream telnetOutputStream = telnet.getOutputStream();
            Thread thread2 = new Thread(telnet);
            thread2.setPriority(Thread.currentThread().getPriority() + 1);
            thread2.start();
            byte[] byArray = new byte[1024];
            while ((n2 = System.in.read()) >= 0) {
                byArray[0] = (byte)n2;
                int n3 = System.in.available();
                if (n3 > 0) {
                    if (n3 > byArray.length - 1) {
                        n3 = byArray.length - 1;
                    }
                    n3 = System.in.read(byArray, 1, n3);
                }
                telnetOutputStream.write(byArray, 0, n3 + 1);
            }
            thread2.stop();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void request(int n, int n2) throws IOException {
        boolean bl = n >= 253;
        boolean bl2 = (n & 1) != 0;
        int n3 = this.optionsState[n2];
        if (bl) {
            n3 = (byte)(n3 >> 3);
        }
        switch (n3 & 7) {
            case 0: {
                if (!bl2) break;
                n3 = 3;
                this.out.writeCommand(n, n2);
                break;
            }
            case 5: {
                if (bl2) break;
                n3 = 1;
                this.out.writeCommand(n, n2);
                break;
            }
            case 1: {
                if (!bl2) break;
                n3 = 2;
                break;
            }
            case 2: {
                if (bl2) break;
                n3 = 1;
                break;
            }
            case 3: {
                if (!bl2) {
                    n3 = 4;
                }
            }
            case 4: {
                if (!bl2) break;
                n3 = 3;
                break;
            }
        }
        n3 = bl ? (int)((byte)(this.optionsState[n2] & 0xC7 | n3 << 3)) : (int)((byte)(this.optionsState[n2] & 0xF8 | n3));
        this.optionsState[n2] = n3;
    }

    public void run() {
        try {
            int n;
            TelnetInputStream telnetInputStream = this.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = telnetInputStream.read()) >= 0) {
                byArray[0] = (byte)n;
                int n2 = telnetInputStream.available();
                if (n2 > 0) {
                    if (n2 > byArray.length - 1) {
                        n2 = byArray.length - 1;
                    }
                    n2 = telnetInputStream.read(byArray, 1, n2);
                }
                System.out.write(byArray, 0, n2 + 1);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(-1);
        }
    }

    public void subCommand(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        switch (by) {
            case 31: {
                if (n2 != 5) break;
                this.windowWidth = (short)((byArray[1] << 8) + (byArray[2] & 0xFF));
                this.windowHeight = (short)((byArray[3] << 8) + (byArray[4] & 0xFF));
                return;
            }
            case 24: {
                byte[] byArray2 = new byte[n2 - 1];
                System.arraycopy(byArray, 1, byArray2, 0, n2 - 1);
                this.terminalType = byArray2;
                System.err.println("terminal type: '" + new String(byArray2) + "'");
                return;
            }
            case 34: {
                System.err.println("SBCommand LINEMODE " + byArray[1] + " len:" + n2);
                if (byArray[1] != 3) break;
                int n3 = 2;
                while (n3 + 2 < n2) {
                    System.err.println("  " + byArray[n3] + "," + byArray[n3 + 1] + "," + byArray[n3 + 2]);
                    n3 += 3;
                }
                return;
            }
        }
    }

    static void usage() {
        System.err.println("Usage:  [java] kawa.Telnet HOST [PORT#]");
        System.exit(-1);
    }
}

