/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.expr.Special;
import gnu.kawa.lispexpr.ScmRead;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Named;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure1;
import gnu.mapping.SFormat;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.AutoloadSyntax;
import kawa.lang.CompileFile;
import kawa.lang.Eval;
import kawa.lang.Lambda;
import kawa.lang.Quote;
import kawa.lang.SpecialType;
import kawa.lang.Syntax;
import kawa.lang.Translator;
import kawa.repl;
import kawa.standard.NumberCompare;
import kawa.standard.ParseFormat;
import kawa.standard.ScmEnv;
import kawa.standard.and_or;
import kawa.standard.ass;
import kawa.standard.begin;
import kawa.standard.convert;
import kawa.standard.define;
import kawa.standard.define_alias;
import kawa.standard.define_autoload;
import kawa.standard.define_class;
import kawa.standard.define_member_alias;
import kawa.standard.define_syntax;
import kawa.standard.define_unit;
import kawa.standard.define_variable;
import kawa.standard.eq_p;
import kawa.standard.equal_p;
import kawa.standard.eqv_p;
import kawa.standard.let_syntax;
import kawa.standard.map;
import kawa.standard.mem;
import kawa.standard.not;
import kawa.standard.object;
import kawa.standard.prim_method;
import kawa.standard.prim_throw;
import kawa.standard.readchar;
import kawa.standard.require;
import kawa.standard.setter;
import kawa.standard.syntax_case;
import kawa.standard.syntax_rules;

public class Scheme
extends Interpreter {
    public static Environment nullEnvironment;
    static Environment r4Environment;
    static Environment r5Environment;
    protected static Environment kawaEnvironment;
    public static SpecialType byteType;
    public static SpecialType shortType;
    public static SpecialType intType;
    public static SpecialType longType;
    public static SpecialType floatType;
    public static SpecialType doubleType;
    public static SpecialType booleanType;
    public static SpecialType charType;
    public static SpecialType voidType;
    static Scheme instance;
    static int scheme_counter;
    public static Procedure1 parseFormat;
    static Hashtable types;

    static {
        byteType = new SpecialType(Type.byte_type);
        shortType = new SpecialType(Type.short_type);
        intType = new SpecialType(Type.int_type);
        longType = new SpecialType(Type.long_type);
        floatType = new SpecialType(Type.float_type);
        doubleType = new SpecialType(Type.double_type);
        charType = new SpecialType(Type.char_type);
        voidType = new SpecialType(Type.void_type);
        scheme_counter = 0;
        parseFormat = new ParseFormat(false);
    }

    public Scheme() {
        if (Interpreter.defaultInterpreter == null) {
            Interpreter.defaultInterpreter = this;
        }
        if (kawaEnvironment == null) {
            this.initScheme();
        }
        this.environ = new ScmEnv(kawaEnvironment);
        this.environ.setName("interaction-environment." + ++scheme_counter);
        if (instance == null) {
            instance = this;
        }
    }

    public Scheme(Environment environment) {
        this.environ = environment;
    }

    public static synchronized Environment builtin() {
        if (kawaEnvironment == null) {
            new Scheme();
        }
        return kawaEnvironment;
    }

    protected void define_proc(Named named) {
        this.define(named.getName(), named);
    }

    protected void define_proc(String string, Named named) {
        if (named.getName() == null) {
            named.setName(string);
        }
        this.define(string, named);
    }

    protected void define_proc(String string, String string2) {
        this.define(string, new AutoloadProcedure(string, string2));
    }

    protected void define_syntax(String string, String string2) {
        this.define(string, new AutoloadSyntax(string, string2));
    }

    protected void define_syntax(String string, Syntax syntax2) {
        if (syntax2.getName() == null) {
            syntax2.setName(string);
        }
        this.define(string, syntax2);
    }

    public static String demangleName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                char c;
                block9: {
                    block7: {
                        char c2;
                        char c3;
                        block8: {
                            char c4;
                            block5: {
                                c = string.charAt(n2);
                                if (bl3) {
                                    c = Character.toLowerCase(c);
                                    bl3 = false;
                                }
                                if (c != 'i' || n2 != 0 || n <= 2 || string.charAt(n2 + 1) != 's' || Character.isLowerCase(c4 = string.charAt(n2 + 2))) break block5;
                                bl = true;
                                bl2 = true;
                                ++n2;
                                if (Character.isUpperCase(c4) || Character.isTitleCase(c4)) {
                                    stringBuffer.append(Character.toLowerCase(c4));
                                    ++n2;
                                }
                                break block6;
                            }
                            if (c != '$' || n2 + 2 >= n) break block7;
                            c3 = string.charAt(n2 + 1);
                            c4 = Compilation.demangle2(c3, c2 = string.charAt(n2 + 2));
                            if (c4 == '\uffff') break block8;
                            stringBuffer.append(c4);
                            n2 += 2;
                            bl = true;
                            bl3 = true;
                            break block6;
                        }
                        if (c3 != 'T' || c2 != 'o' || n2 + 3 >= n || string.charAt(n2 + 3) != '$') break block9;
                        stringBuffer.append("->");
                        n2 += 3;
                        bl = true;
                        bl3 = true;
                        break block6;
                    }
                    if (n2 > 1 && (Character.isUpperCase(c) || Character.isTitleCase(c)) && Character.isLowerCase(string.charAt(n2 - 1))) {
                        stringBuffer.append('-');
                        bl = true;
                        c = Character.toLowerCase(c);
                    }
                }
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (bl2) {
            stringBuffer.append('?');
        }
        return bl ? stringBuffer.toString() : string;
    }

    public static Object eval(InPort inPort, Environment environment) {
        try {
            SourceMessages sourceMessages = new SourceMessages();
            Object object2 = CompileFile.readBody(inPort, sourceMessages);
            if (sourceMessages.seenErrors()) {
                throw new SyntaxException(sourceMessages);
            }
            return Eval.evalBody(object2, environment, sourceMessages);
        }
        catch (SyntaxException syntaxException) {
            throw new RuntimeException("eval: errors while compiling:\n" + syntaxException.getMessages().toString(20));
        }
    }

    public static Object eval(Object object2, Environment environment) {
        return Eval.eval(object2, environment);
    }

    public Object eval(String string) {
        return Scheme.eval(string, this.environ);
    }

    public static Object eval(String string, Environment environment) {
        return Scheme.eval(new CharArrayInPort(string), environment);
    }

    public static Type exp2Type(Expression expression) {
        return Scheme.getInstance().getTypeFor(expression);
    }

    public static Scheme getInstance() {
        if (kawaEnvironment == null) {
            new Scheme();
        }
        return instance;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new ScmRead(inPort, sourceMessages);
    }

    public String getName() {
        return "Scheme";
    }

    public static Type getNamedType(String string) {
        Type type;
        if (types == null) {
            booleanType = new SpecialType(Type.boolean_type, Scheme.getInstance());
            types = new Hashtable();
            types.put("void", voidType);
            types.put("int", intType);
            types.put("char", charType);
            types.put("boolean", booleanType);
            types.put("byte", byteType);
            types.put("short", shortType);
            types.put("long", longType);
            types.put("float", floatType);
            types.put("double", doubleType);
            types.put("Object", Type.pointer_type);
            types.put("java.lang.Object", Type.pointer_type);
            types.put("String", Type.string_type);
            types.put("object", Type.pointer_type);
            types.put("number", ClassType.make("gnu.math.Numeric"));
            types.put("quantity", ClassType.make("gnu.math.Quantity"));
            types.put("complex", ClassType.make("gnu.math.Complex"));
            types.put("real", ClassType.make("gnu.math.RealNum"));
            types.put("rational", ClassType.make("gnu.math.RatNum"));
            types.put("integer", ClassType.make("gnu.math.IntNum"));
            types.put("symbol", ClassType.make("java.lang.String"));
            types.put("keyword", ClassType.make("gnu.expr.Keyword"));
            types.put("list", ClassType.make("gnu.kawa.util.LList"));
            types.put("pair", ClassType.make("gnu.kawa.util.Pair"));
            types.put("string", ClassType.make("gnu.kawa.util.FString"));
            types.put("abstract-string", ClassType.make("gnu.kawa.util.AbstractString"));
            types.put("character", ClassType.make("gnu.text.Char"));
            types.put("vector", ClassType.make("gnu.kawa.util.FVector"));
            types.put("function", ClassType.make("gnu.mapping.Procedure"));
            types.put("procedure", ClassType.make("gnu.mapping.Procedure"));
            types.put("input-port", ClassType.make("gnu.mapping.InPort"));
            types.put("output-port", ClassType.make("gnu.mapping.OutPort"));
            types.put("string-output-port", ClassType.make("gnu.mapping.CharArrayOutPort"));
            types.put("record", ClassType.make("kawa.lang.Record"));
            types.put("type", ClassType.make("gnu.bytecode.Type"));
            types.put("class-type", ClassType.make("gnu.bytecode.ClassType"));
            types.put("s8vector", ClassType.make("gnu.kawa.util.S8Vector"));
            types.put("u8vector", ClassType.make("gnu.kawa.util.U8Vector"));
            types.put("s16vector", ClassType.make("gnu.kawa.util.S16Vector"));
            types.put("u16vector", ClassType.make("gnu.kawa.util.U16Vector"));
            types.put("s32vector", ClassType.make("gnu.kawa.util.S32Vector"));
            types.put("u32vector", ClassType.make("gnu.kawa.util.U32Vector"));
            types.put("s64vector", ClassType.make("gnu.kawa.util.S64Vector"));
            types.put("u64vector", ClassType.make("gnu.kawa.util.U64Vector"));
            types.put("f32vector", ClassType.make("gnu.kawa.util.F32Vector"));
            types.put("f64vector", ClassType.make("gnu.kawa.util.F64Vector"));
        }
        if ((type = (Type)types.get(string)) == null && string.startsWith("elisp:")) {
            Class clazz = Scheme.getNamedType(string.substring(6)).getReflectClass();
            type = Interpreter.getInstance("elisp").getTypeFor(clazz);
            types.put(string, type);
        }
        return type;
    }

    public Environment getNewEnvironment() {
        if (kawaEnvironment == null) {
            this.initScheme();
        }
        ScmEnv scmEnv = new ScmEnv(kawaEnvironment);
        scmEnv.setName("interaction-environment." + ++scheme_counter);
        return scmEnv;
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            return Scheme.getNamedType(clazz.getName());
        }
        return Type.make(clazz);
    }

    public Type getTypeFor(String string) {
        return Scheme.string2Type(string);
    }

    public static Type getTypeValue(Expression expression) {
        return Scheme.getInstance().getTypeFor(expression);
    }

    public void initScheme() {
        nullEnvironment = new Environment();
        nullEnvironment.setName("null-environment");
        this.environ = nullEnvironment;
        Lambda lambda15 = new Lambda();
        lambda15.setKeywords(Special.optional, Special.rest, Special.key);
        this.define_syntax("lambda", lambda15);
        this.define("quote", new Quote());
        this.define_syntax("define", new define(lambda15, false));
        this.define_syntax("define-private", new define(lambda15, true));
        this.define_syntax("define-constant", new define(lambda15, false, true));
        this.define_syntax("define-autoload", new define_autoload(false));
        this.define_syntax("define-autoloads-from-file", new define_autoload(true));
        this.define_syntax("if", "kawa.standard.ifp");
        this.define_syntax("set!", "kawa.standard.set_b");
        this.define_syntax("cond", "kawa.lib.std_syntax");
        this.define_syntax("case", "kawa.lib.std_syntax");
        this.define_syntax("and", "kawa.lib.std_syntax");
        this.define("or", new and_or(false, this));
        this.define_syntax("%let", "kawa.standard.let");
        this.define_syntax("let", "kawa.lib.std_syntax");
        this.define_syntax("%let-decl", "kawa.lib.std_syntax");
        this.define_syntax("%let-init", "kawa.lib.std_syntax");
        this.define_syntax("let*", "kawa.lib.std_syntax");
        this.define_syntax("letrec", "kawa.standard.letrec");
        this.define("begin", new begin());
        this.define_syntax("do", "kawa.lib.std_syntax");
        this.define_syntax("delay", "kawa.lib.std_syntax");
        this.define_proc("%make-promise", "kawa.lib.std_syntax");
        this.define_syntax("quasiquote", "kawa.standard.quasiquote");
        this.define("define-syntax", new define_syntax());
        this.define("syntax-rules", new syntax_rules());
        this.define("syntax-case", new syntax_case());
        this.define("let-syntax", new let_syntax(false));
        this.define("letrec-syntax", new let_syntax(true));
        r4Environment = new Environment(nullEnvironment);
        r4Environment.setName("r4rs-environment");
        this.environ = r4Environment;
        this.define_proc("not", new not(this));
        this.define_proc("boolean?", "kawa.lib.misc");
        eqv_p eqv_p2 = new eqv_p(this);
        this.define_proc("eqv?", eqv_p2);
        eq_p eq_p2 = new eq_p(this);
        this.define_proc("eq?", eq_p2);
        equal_p equal_p2 = new equal_p(this);
        this.define_proc("equal?", equal_p2);
        this.define_proc("pair?", "kawa.lib.lists");
        this.define_proc("cons", "kawa.lib.lists");
        this.define_proc("car", "kawa.standard.car");
        this.define_proc("cdr", "kawa.standard.cdr");
        this.define_proc("set-car!", "kawa.lib.lists");
        this.define_proc("set-cdr!", "kawa.lib.lists");
        this.define_proc("caar", "kawa.standard.cxr");
        this.define_proc("cadr", "kawa.standard.cxr");
        this.define_proc("cdar", "kawa.standard.cxr");
        this.define_proc("cddr", "kawa.standard.cxr");
        this.define_proc("caaar", "kawa.standard.cxr");
        this.define_proc("caadr", "kawa.standard.cxr");
        this.define_proc("cadar", "kawa.standard.cxr");
        this.define_proc("caddr", "kawa.standard.cxr");
        this.define_proc("cdaar", "kawa.standard.cxr");
        this.define_proc("cdadr", "kawa.standard.cxr");
        this.define_proc("cddar", "kawa.standard.cxr");
        this.define_proc("cdddr", "kawa.standard.cxr");
        this.define_proc("caaaar", "kawa.standard.cxr");
        this.define_proc("caaadr", "kawa.standard.cxr");
        this.define_proc("caadar", "kawa.standard.cxr");
        this.define_proc("caaddr", "kawa.standard.cxr");
        this.define_proc("cadaar", "kawa.standard.cxr");
        this.define_proc("cadadr", "kawa.standard.cxr");
        this.define_proc("caddar", "kawa.standard.cxr");
        this.define_proc("cadddr", "kawa.standard.cxr");
        this.define_proc("cdaaar", "kawa.standard.cxr");
        this.define_proc("cdaadr", "kawa.standard.cxr");
        this.define_proc("cdadar", "kawa.standard.cxr");
        this.define_proc("cdaddr", "kawa.standard.cxr");
        this.define_proc("cddaar", "kawa.standard.cxr");
        this.define_proc("cddadr", "kawa.standard.cxr");
        this.define_proc("cdddar", "kawa.standard.cxr");
        this.define_proc("cddddr", "kawa.standard.cxr");
        this.define_proc("null?", "kawa.lib.lists");
        this.define_proc("list?", "kawa.standard.list_p");
        this.define_proc("list", "kawa.standard.list_v");
        this.define_proc("length", "kawa.lib.lists");
        this.define_proc("append", "kawa.standard.append");
        this.define_proc("reverse", "kawa.standard.reverse");
        this.define_proc("list-tail", "kawa.standard.list_tail");
        this.define_proc("list-ref", "kawa.standard.list_ref");
        Procedure procedure = new mem("memq", eq_p2);
        this.define(procedure.getName(), procedure);
        procedure = new mem("memv", eqv_p2);
        this.define(procedure.getName(), procedure);
        procedure = new mem("member", equal_p2);
        this.define(procedure.getName(), procedure);
        procedure = new ass("assq", eq_p2);
        this.define(procedure.getName(), procedure);
        procedure = new ass("assv", eqv_p2);
        this.define(procedure.getName(), procedure);
        procedure = new ass("assoc", equal_p2);
        this.define(procedure.getName(), procedure);
        this.define_proc("symbol?", "kawa.lib.misc");
        this.define_proc("symbol->string", "kawa.lib.misc");
        this.define_proc("string->symbol", "kawa.lib.misc");
        this.define_proc("number?", "kawa.lib.numbers");
        this.define_proc("quantity?", "kawa.lib.numbers");
        this.define_proc("complex?", "kawa.lib.numbers");
        this.define_proc("real?", "kawa.lib.numbers");
        this.define_proc("rational?", "kawa.lib.numbers");
        this.define_proc("integer?", "kawa.standard.integer_p");
        this.define_proc("exact?", "kawa.standard.exact_p");
        this.define_proc("inexact?", "kawa.standard.inexact_p");
        this.define_proc("=", NumberCompare.$Eq);
        this.define_proc("<", NumberCompare.$Ls);
        this.define_proc(">", NumberCompare.$Gr);
        this.define_proc("<=", NumberCompare.$Ls$Eq);
        this.define_proc(">=", NumberCompare.$Gr$Eq);
        this.define_proc("zero?", "kawa.lib.numbers");
        this.define_proc("positive?", "kawa.standard.positive_p");
        this.define_proc("negative?", "kawa.lib.numbers");
        this.define_proc("odd?", "kawa.lib.numbers");
        this.define_proc("even?", "kawa.lib.numbers");
        this.define_proc("max", "kawa.standard.max");
        this.define_proc("min", "kawa.standard.min");
        this.define_proc("+", "kawa.standard.plus_oper");
        this.define_proc("-", "kawa.standard.minus_oper");
        this.define_proc("*", "kawa.standard.multiply_oper");
        this.define_proc("/", "kawa.standard.divide_oper");
        this.define_proc("abs", "kawa.lib.numbers");
        this.define_proc("quotient", "kawa.lib.numbers");
        this.define_proc("remainder", "kawa.lib.numbers");
        this.define_proc("modulo", "kawa.standard.modulo");
        this.define_proc("gcd", "kawa.standard.gcd");
        this.define_proc("lcm", "kawa.standard.lcm");
        this.define_proc("numerator", "kawa.lib.numbers");
        this.define_proc("denominator", "kawa.lib.numbers");
        this.define_proc("floor", "kawa.standard.floor");
        this.define_proc("ceiling", "kawa.standard.ceiling");
        this.define_proc("truncate", "kawa.standard.truncate");
        this.define_proc("round", "kawa.standard.round");
        this.define_proc("rationalize", "kawa.standard.rationalize");
        this.define_proc("exp", "kawa.lib.numbers");
        this.define_proc("log", "kawa.lib.numbers");
        this.define_proc("sin", "kawa.lib.numbers");
        this.define_proc("cos", "kawa.lib.numbers");
        this.define_proc("tan", "kawa.lib.numbers");
        this.define_proc("asin", "kawa.lib.numbers");
        this.define_proc("acos", "kawa.lib.numbers");
        this.define_proc("atan", "kawa.standard.atan");
        this.define_proc("sqrt", "kawa.standard.sqrt");
        this.define_proc("expt", "kawa.standard.expt");
        this.define_proc("make-rectangular", "kawa.lib.numbers");
        this.define_proc("make-polar", "kawa.lib.numbers");
        this.define_proc("real-part", "kawa.lib.numbers");
        this.define_proc("imag-part", "kawa.lib.numbers");
        this.define_proc("magnitude", "kawa.lib.numbers");
        this.define_proc("angle", "kawa.lib.numbers");
        this.define_proc("exact->inexact", "kawa.standard.exact2inexact");
        this.define_proc("inexact->exact", "kawa.standard.inexact2exact");
        this.define_proc("number->string", "kawa.standard.number2string");
        this.define_proc("string->number", "kawa.standard.string2number");
        this.define_proc("char?", "kawa.lib.characters");
        this.define_proc("char=?", "kawa.lib.characters");
        this.define_proc("char<?", "kawa.lib.characters");
        this.define_proc("char>?", "kawa.lib.characters");
        this.define_proc("char<=?", "kawa.lib.characters");
        this.define_proc("char>=?", "kawa.lib.characters");
        this.define_proc("char-ci=?", "kawa.lib.characters");
        this.define_proc("char-ci<?", "kawa.lib.characters");
        this.define_proc("char-ci>?", "kawa.lib.characters");
        this.define_proc("char-ci<=?", "kawa.lib.characters");
        this.define_proc("char-ci>=?", "kawa.lib.characters");
        this.define_proc("char-alphabetic?", "kawa.lib.characters");
        this.define_proc("char-numeric?", "kawa.lib.characters");
        this.define_proc("char-whitespace?", "kawa.lib.characters");
        this.define_proc("char-upper-case?", "kawa.lib.characters");
        this.define_proc("char-lower-case?", "kawa.lib.characters");
        this.define_proc("char->integer", "kawa.lib.characters");
        this.define_proc("integer->char", "kawa.lib.characters");
        this.define_proc("char-upcase", "kawa.lib.characters");
        this.define_proc("char-downcase", "kawa.lib.characters");
        this.define_proc("string?", "kawa.lib.strings");
        this.define_proc("make-string", "kawa.lib.strings");
        this.define_proc("string", "kawa.standard.string_v");
        this.define_proc("string-length", "kawa.lib.strings");
        this.define_proc("string-ref", "kawa.lib.strings");
        this.define_proc("string-set!", "kawa.lib.strings");
        this.define_proc("string=?", "kawa.lib.strings");
        this.define_proc("string-ci=?", "kawa.standard.string_ci_equal_p");
        this.define_proc("string<?", "kawa.standard.string_lessthan_p");
        this.define_proc("string>?", "kawa.standard.string_greaterthan_p");
        this.define_proc("string<=?", "kawa.standard.string_lessequal_p");
        this.define_proc("string>=?", "kawa.standard.string_greaterequal_p");
        this.define_proc("string-ci<?", "kawa.standard.string_ci_lessthan_p");
        this.define_proc("string-ci>?", "kawa.standard.string_ci_greaterthan_p");
        this.define_proc("string-ci<=?", "kawa.standard.string_ci_lessequal_p");
        this.define_proc("string-ci>=?", "kawa.standard.string_ci_greaterequal_p");
        this.define_proc("substring", "kawa.lib.strings");
        this.define_proc("string-append", "kawa.standard.string_append");
        this.define_proc("string->list", "kawa.standard.string2list");
        this.define_proc("list->string", "kawa.standard.list2string");
        this.define_proc("string-copy", "kawa.lib.strings");
        this.define_proc("string-fill!", "kawa.lib.strings");
        this.define_proc("vector?", "kawa.lib.vectors");
        this.define_proc("make-vector", "kawa.lib.vectors");
        this.define_proc("vector", "kawa.lib.vectors");
        this.define_proc("vector-length", "kawa.lib.vectors");
        this.define_proc("vector-ref", "kawa.lib.vectors");
        this.define_proc("vector-set!", "kawa.lib.vectors");
        this.define_proc("list->vector", "kawa.lib.vectors");
        this.define_proc("vector->list", "kawa.standard.vector2list");
        this.define_proc("vector-fill!", "kawa.lib.vectors");
        this.define_proc("vector-append", "kawa.standard.vector_append");
        this.define_proc("procedure?", "kawa.lib.misc");
        this.define_proc("apply", "kawa.standard.apply");
        this.define_proc(new map(true));
        this.define_proc(new map(false));
        this.define_proc("call-with-current-continuation", "kawa.standard.callcc");
        this.define_proc("call/cc", "kawa.standard.callcc");
        this.define_proc("force", "kawa.standard.force");
        this.define_proc("call-with-input-file", "kawa.standard.call_with_input_file");
        this.define_proc("call-with-output-file", "kawa.standard.call_with_output_file");
        this.define_proc("input-port?", "kawa.lib.ports");
        this.define_proc("output-port?", "kawa.lib.ports");
        this.define_proc("current-input-port", "kawa.lib.ports");
        this.define_proc("current-output-port", "kawa.lib.ports");
        this.define_proc("with-input-from-file", "kawa.standard.with_input_from_file");
        this.define_proc("with-output-to-file", "kawa.standard.with_output_to_file");
        this.define_proc("open-input-file", "kawa.standard.open_input_file");
        this.define_proc("open-output-file", "kawa.standard.open_output_file");
        this.define_proc("close-input-port", "kawa.lib.ports");
        this.define_proc("close-output-port", "kawa.lib.ports");
        this.define_proc("read", "kawa.standard.read");
        this.define_proc("read-line", "kawa.standard.read_line");
        this.define_proc(new readchar(false));
        this.define_proc(new readchar(true));
        this.define_proc("eof-object?", "kawa.lib.ports");
        this.define_proc("char-ready?", "kawa.standard.char_ready_p");
        this.define_proc("write", "kawa.lib.ports");
        this.define_proc("display", "kawa.lib.ports");
        this.define_proc("write-char", "kawa.lib.ports");
        this.define_proc("newline", "kawa.lib.ports");
        this.define_proc("load", "kawa.standard.load");
        this.define_proc("transcript-off", "kawa.lib.ports");
        this.define_proc("transcript-on", "kawa.lib.ports");
        this.define_proc("call-with-input-string", "kawa.lib.ports");
        this.define_proc("open-input-string", "kawa.lib.ports");
        this.define_proc("open-output-string", "kawa.lib.ports");
        this.define_proc("get-output-string", "kawa.lib.ports");
        this.define_proc("call-with-output-string", "kawa.standard.call_with_output_string");
        this.define_proc("force-output", "kawa.lib.ports");
        this.define_proc("port-line", "kawa.lib.ports");
        this.define_proc("set-port-line!", "kawa.lib.ports");
        this.define_proc("port-column", "kawa.lib.ports");
        this.define_proc("input-port-line-number", "kawa.lib.ports");
        this.define_proc("set-input-port-line-number!", "kawa.lib.ports");
        this.define_proc("input-port-column-number", "kawa.lib.ports");
        this.define_proc("input-port-read-state", "kawa.lib.ports");
        this.define_proc("default-prompter", "kawa.lib.ports");
        this.define_proc("input-port-prompter", "kawa.lib.ports");
        this.define_proc("set-input-port-prompter!", "kawa.lib.ports");
        this.define_syntax("%syntax-error", "kawa.standard.syntax_error");
        r5Environment = new Environment(r4Environment);
        r5Environment.setName("r5rs-environment");
        this.environ = r5Environment;
        this.define_proc("values", "kawa.lib.misc");
        this.define_proc("call-with-values", "kawa.standard.call_with_values");
        this.define_proc("eval", "kawa.lang.Eval");
        this.define_proc("repl", new repl(this));
        this.define_proc("scheme-report-environment", "kawa.standard.scheme_env");
        this.define_proc("null-environment", "kawa.lib.misc");
        this.define_proc("interaction-environment", "kawa.lib.misc");
        this.define_proc("dynamic-wind", "kawa.lib.syntax");
        this.environ = kawaEnvironment = new Environment(r5Environment);
        this.define_proc("exit", "kawa.lib.thread");
        String string = "arithmetic-shift";
        procedure = new AutoloadProcedure(string, "kawa.standard.ashift");
        this.define(string, procedure);
        this.define("ash", procedure);
        this.define_proc("logand", "kawa.standard.logand");
        this.define_proc("logior", "kawa.standard.logior");
        this.define_proc("logxor", "kawa.standard.logxor");
        this.define_proc("lognot", "kawa.lib.numbers");
        this.define_proc("logop", "kawa.lib.numbers");
        this.define_proc("logbit?", "kawa.lib.numbers");
        this.define_proc("logtest", "kawa.lib.numbers");
        this.define_proc("logcount", "kawa.lib.numbers");
        this.define_proc("bit-extract", "kawa.lib.numbers");
        this.define_proc("integer-length", "kawa.lib.numbers");
        this.define_proc("string-upcase!", "kawa.lib.strings");
        this.define_proc("string-downcase!", "kawa.lib.strings");
        this.define_proc("string-capitalize!", "kawa.lib.strings");
        this.define_proc("string-upcase", "kawa.lib.strings");
        this.define_proc("string-downcase", "kawa.lib.strings");
        this.define_proc("string-capitalize", "kawa.lib.strings");
        this.define_syntax("primitive-virtual-method", new prim_method(182));
        this.define_syntax("primitive-static-method", new prim_method(184));
        this.define_syntax("primitive-interface-method", new prim_method(185));
        this.define_syntax("primitive-constructor", new prim_method(183));
        this.define_syntax("primitive-op1", new prim_method());
        this.define_syntax("primitive-get-field", "kawa.lib.reflection");
        this.define_syntax("primitive-set-field", "kawa.lib.reflection");
        this.define_syntax("primitive-get-static", "kawa.lib.reflection");
        this.define_syntax("primitive-set-static", "kawa.lib.reflection");
        this.define_syntax("primitive-array-new", "kawa.lib.reflection");
        this.define_syntax("primitive-array-get", "kawa.lib.reflection");
        this.define_syntax("primitive-array-set", "kawa.lib.reflection");
        this.define_syntax("primitive-array-length", "kawa.lib.reflection");
        this.define_proc("subtype?", "kawa.lib.reflection");
        this.define_proc("primitive-throw", new prim_throw());
        this.define_syntax("try-finally", "kawa.standard.try_finally");
        this.define_syntax("try-catch", "kawa.standard.try_catch");
        this.define_proc("throw", "kawa.standard.throw_name");
        this.define_proc("catch", "kawa.lib.syntax");
        this.define_proc("error", "kawa.lib.syntax");
        this.define_proc("as", convert.getInstance());
        this.define_proc("instance?", new InstanceOf(this));
        this.define_syntax("synchronized", "kawa.standard.synchronizd");
        object object2 = new object(lambda15);
        this.define_syntax("object", object2);
        this.define_syntax("define-class", new define_class(object2));
        this.define_syntax("this", "kawa.lib.syntax");
        this.define_proc("make", Invoke.make);
        this.define_proc("slot-ref", SlotGet.field);
        this.define_proc("slot-set!", "gnu.kawa.reflect.SlotSet");
        this.define_proc("field", SlotGet.field);
        this.define_proc("class-methods", "gnu.kawa.reflect.ClassMethods");
        this.define_proc("static-field", SlotGet.staticField);
        this.define_proc("invoke", Invoke.invoke);
        this.define_proc("invoke-static", Invoke.invokeStatic);
        this.define_proc("file-exists?", "kawa.lib.files");
        this.define_proc("file-directory?", "kawa.lib.files");
        this.define_proc("file-readable?", "kawa.lib.files");
        this.define_proc("file-writable?", "kawa.lib.files");
        this.define_proc("delete-file", "kawa.lib.files");
        this.define_proc("system-tmpdir", "kawa.lib.files");
        this.define_proc("make-temporary-file", "kawa.lib.files");
        this.define_proc("rename-file", "kawa.lib.files");
        this.define_proc("copy-file", "kawa.lib.files");
        this.define_proc("create-directory", "kawa.lib.files");
        this.define_proc("->pathname", "kawa.lib.files");
        this.define("port-char-encoding", Boolean.TRUE);
        this.define("symbol-read-case", "P");
        this.define_proc("system", "kawa.lib.system");
        this.define_proc("make-process", "kawa.lib.system");
        this.define_proc("tokenize-string-to-string-array", "kawa.lib.system");
        this.define_proc("tokenize-string-using-shell", "kawa.lib.system");
        if ("/".equals(System.getProperty("file.separator"))) {
            this.define("command-parse", this.lookup("tokenize-string-using-shell"));
        } else {
            this.define("command-parse", this.lookup("tokenize-string-to-string-array"));
        }
        this.define_proc("record-accessor", "kawa.lib.reflection");
        this.define_proc("record-modifier", "kawa.lib.reflection");
        this.define_proc("record-predicate", "kawa.lib.reflection");
        this.define_proc("record-constructor", "kawa.lib.reflection");
        this.define_proc("make-record-type", "kawa.lib.reflection");
        this.define_proc("record-type-descriptor", "kawa.lib.reflection");
        this.define_proc("record-type-name", "kawa.lib.reflection");
        this.define_proc("record-type-field-names", "kawa.lib.reflection");
        this.define_proc("record?", "kawa.lib.reflection");
        this.define_syntax("when", "kawa.lib.syntax");
        this.define_syntax("unless", "kawa.lib.syntax");
        this.define_syntax("fluid-let", "kawa.standard.fluid_let");
        this.define_syntax("constant-fold", "kawa.standard.constant_fold");
        this.define_proc("compile-file", "kawa.lang.CompileFile");
        this.define_proc("load-compiled", "kawa.lang.loadcompiled");
        this.define_proc("environment-bound?", "kawa.lib.misc");
        this.define_proc("scheme-implementation-version", "kawa.lib.misc");
        this.define_proc("scheme-window", "kawa.lib.misc");
        this.define_syntax("define-procedure", "kawa.lib.syntax");
        this.define_proc("make-procedure", "kawa.lib.misc");
        this.define_proc("procedure-property", "kawa.lib.misc");
        this.define_proc("set-procedure-property!", "kawa.lib.misc");
        this.define_proc("quantity->number", "kawa.standard.quantity2number");
        this.define_proc("quantity->unit", "kawa.standard.quantity2unit");
        this.define_proc("make-quantity", "kawa.standard.make_quantity");
        this.define_syntax("define-unit", new define_unit(false));
        this.define_syntax("define-base-unit", new define_unit(true));
        this.define_proc("gentemp", "kawa.lib.syntax");
        this.define_syntax("defmacro", "kawa.lib.syntax");
        this.define_proc("setter", setter.setterProcedure);
        this.define_syntax("future", "kawa.lib.thread");
        this.define_proc("%make-future", "kawa.standard.make_future");
        this.define_proc("sleep", "kawa.standard.sleep");
        this.define_syntax("trace", "kawa.lib.trace");
        this.define_syntax("untrace", "kawa.lib.trace");
        this.define_proc("format", "kawa.standard.format");
        this.define_proc("parse-format", parseFormat);
        this.define_proc("emacs:read", "kawa.lib.emacs");
        this.define_proc("keyword?", "kawa.lib.keywords");
        this.define_proc("keyword->string", "kawa.lib.keywords");
        this.define_proc("string->keyword", "kawa.lib.keywords");
        this.define_syntax("location", "kawa.standard.location");
        this.define("define-alias", new define_alias());
        this.define("define-variable", new define_variable());
        this.define("define-member-alias", new define_member_alias());
        this.define("require", new require());
        this.define_syntax("module-name", "kawa.standard.module_name");
        this.define_syntax("module-extends", "kawa.standard.module_extends");
        this.define_syntax("module-implements", "kawa.standard.module_implements");
        this.define_syntax("module-static", "kawa.standard.module_static");
        this.define_syntax("module-export", "kawa.standard.export");
        this.define_proc("s8vector?", "kawa.lib.uniform");
        this.define_proc("make-s8vector", "kawa.lib.uniform");
        this.define_proc("s8vector", "kawa.lib.uniform");
        this.define_proc("s8vector-length", "kawa.lib.uniform");
        this.define_proc("s8vector-ref", "kawa.lib.uniform");
        this.define_proc("s8vector-set!", "kawa.lib.uniform");
        this.define_proc("s8vector->list", "kawa.lib.uniform");
        this.define_proc("list->s8vector", "kawa.lib.uniform");
        this.define_proc("u8vector?", "kawa.lib.uniform");
        this.define_proc("make-u8vector", "kawa.lib.uniform");
        this.define_proc("u8vector", "kawa.lib.uniform");
        this.define_proc("u8vector-length", "kawa.lib.uniform");
        this.define_proc("u8vector-ref", "kawa.lib.uniform");
        this.define_proc("u8vector-set!", "kawa.lib.uniform");
        this.define_proc("u8vector->list", "kawa.lib.uniform");
        this.define_proc("list->u8vector", "kawa.lib.uniform");
        this.define_proc("s16vector?", "kawa.lib.uniform");
        this.define_proc("make-s16vector", "kawa.lib.uniform");
        this.define_proc("s16vector", "kawa.lib.uniform");
        this.define_proc("s16vector-length", "kawa.lib.uniform");
        this.define_proc("s16vector-ref", "kawa.lib.uniform");
        this.define_proc("s16vector-set!", "kawa.lib.uniform");
        this.define_proc("s16vector->list", "kawa.lib.uniform");
        this.define_proc("list->s16vector", "kawa.lib.uniform");
        this.define_proc("u16vector?", "kawa.lib.uniform");
        this.define_proc("make-u16vector", "kawa.lib.uniform");
        this.define_proc("u16vector", "kawa.lib.uniform");
        this.define_proc("u16vector-length", "kawa.lib.uniform");
        this.define_proc("u16vector-ref", "kawa.lib.uniform");
        this.define_proc("u16vector-set!", "kawa.lib.uniform");
        this.define_proc("u16vector->list", "kawa.lib.uniform");
        this.define_proc("list->u16vector", "kawa.lib.uniform");
        this.define_proc("s32vector?", "kawa.lib.uniform");
        this.define_proc("make-s32vector", "kawa.lib.uniform");
        this.define_proc("s32vector", "kawa.lib.uniform");
        this.define_proc("s32vector-length", "kawa.lib.uniform");
        this.define_proc("s32vector-ref", "kawa.lib.uniform");
        this.define_proc("s32vector-set!", "kawa.lib.uniform");
        this.define_proc("s32vector->list", "kawa.lib.uniform");
        this.define_proc("list->s32vector", "kawa.lib.uniform");
        this.define_proc("u32vector?", "kawa.lib.uniform");
        this.define_proc("make-u32vector", "kawa.lib.uniform");
        this.define_proc("u32vector", "kawa.lib.uniform");
        this.define_proc("u32vector-length", "kawa.lib.uniform");
        this.define_proc("u32vector-ref", "kawa.lib.uniform");
        this.define_proc("u32vector-set!", "kawa.lib.uniform");
        this.define_proc("u32vector->list", "kawa.lib.uniform");
        this.define_proc("list->u32vector", "kawa.lib.uniform");
        this.define_proc("s64vector?", "kawa.lib.uniform");
        this.define_proc("make-s64vector", "kawa.lib.uniform");
        this.define_proc("s64vector", "kawa.lib.uniform");
        this.define_proc("s64vector-length", "kawa.lib.uniform");
        this.define_proc("s64vector-ref", "kawa.lib.uniform");
        this.define_proc("s64vector-set!", "kawa.lib.uniform");
        this.define_proc("s64vector->list", "kawa.lib.uniform");
        this.define_proc("list->s64vector", "kawa.lib.uniform");
        this.define_proc("u64vector?", "kawa.lib.uniform");
        this.define_proc("make-u64vector", "kawa.lib.uniform");
        this.define_proc("u64vector", "kawa.lib.uniform");
        this.define_proc("u64vector-length", "kawa.lib.uniform");
        this.define_proc("u64vector-ref", "kawa.lib.uniform");
        this.define_proc("u64vector-set!", "kawa.lib.uniform");
        this.define_proc("u64vector->list", "kawa.lib.uniform");
        this.define_proc("list->u64vector", "kawa.lib.uniform");
        this.define_proc("f32vector?", "kawa.lib.uniform");
        this.define_proc("make-f32vector", "kawa.lib.uniform");
        this.define_proc("f32vector", "kawa.lib.uniform");
        this.define_proc("f32vector-length", "kawa.lib.uniform");
        this.define_proc("f32vector-ref", "kawa.lib.uniform");
        this.define_proc("f32vector-set!", "kawa.lib.uniform");
        this.define_proc("f32vector->list", "kawa.lib.uniform");
        this.define_proc("list->f32vector", "kawa.lib.uniform");
        this.define_proc("f64vector?", "kawa.lib.uniform");
        this.define_proc("make-f64vector", "kawa.lib.uniform");
        this.define_proc("f64vector", "kawa.lib.uniform");
        this.define_proc("f64vector-length", "kawa.lib.uniform");
        this.define_proc("f64vector-ref", "kawa.lib.uniform");
        this.define_proc("f64vector-set!", "kawa.lib.uniform");
        this.define_proc("f64vector->list", "kawa.lib.uniform");
        this.define_proc("list->f64vector", "kawa.lib.uniform");
        this.define_proc("emacs", "gnu.jemacs.buffer.emacs");
    }

    public static ModuleExp makeModuleExp(Object object2, Translator translator) {
        ModuleExp moduleExp = new ModuleExp();
        Vector vector = new Vector(20);
        SourceMessages sourceMessages = translator.getMessages();
        translator.push(moduleExp);
        translator.scan_body(object2, vector, moduleExp);
        translator.finishModule(moduleExp, vector);
        return moduleExp;
    }

    public void print(Object object2, OutPort outPort) {
        if (object2 == Interpreter.voidObject) {
            return;
        }
        if (object2 instanceof Values) {
            Object[] objectArray = ((Values)object2).getValues();
            int n = 0;
            while (n < objectArray.length) {
                SFormat.print(objectArray[n], outPort);
                outPort.println();
                ++n;
            }
        } else {
            SFormat.print(object2, outPort);
            outPort.println();
        }
        outPort.flush();
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return ScmRead.readObject(inPort);
    }

    public static void registerEnvironment() {
        Scheme scheme = new Scheme();
        Interpreter.defaultInterpreter = scheme;
        Environment.setCurrent(scheme.getEnvironment());
    }

    public static Type string2Type(String string) {
        Type type;
        if (string.endsWith("[]")) {
            type = Scheme.string2Type(string.substring(0, string.length() - 2));
            if (type != null) {
                type = ArrayType.make(type);
            }
        } else {
            type = Scheme.getNamedType(string);
        }
        if (type != null) {
            return type;
        }
        type = Interpreter.string2Type(string);
        if (type != null) {
            types.put(string, type);
        }
        return type;
    }
}

