#ifndef _UNISTD_H
#define _UNISTD_H

#include <io.h>
#include <fcntl.h>
#include <malloc.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>
#include <getopt.h>

#define ftruncate(_fd,_len) _chsize(_fd,_len)

#define strtoll _strtoi64
#define strtoull _strtoui64

//int usleep(unsigned);
int getpid();
int strnlen(const char *, int);
void _tzset(void);
int _cwait(int *status, intptr_t proc, int);
int spawnve(int mode, const char *path, const char * const *argv, const char * const *env);
#define clockid_t int

#ifndef P_NOWAIT
#define P_NOWAIT 1
#define P_WAIT 0
#endif

#define STDOUT_FILENO 1
#define CLOCK_REALTIME 0

#ifdef _USE_32BIT_TIME_T
# undef _stati64
# undef _fstati64
# define _stati64 _stat
# define _fstati64 _fstat
#endif

char *strtok_r(char *s, const char *delim, char **save_ptr);
int ffs(int x);

#ifdef __TINYC__
#define PS_NO_ASM
#endif

#ifndef __TINYC__
# define _strtoui64 strtoull
# define _strtoi64 strtoll
extern int getopt_long_only( int, char * const [], const char *, const struct option *, int * );
#endif

#define IPV6_V6ONLY 27
#define ELOOP 114
#define EAFNOSUPPORT 102

#define LOAD_LIBRARY_SEARCH_SYSTEM32 0x800
#define IO_REPARSE_TAG_SYMLINK (0xA000000CL)
#define VOLUME_NAME_DOS 0x0
#define FILE_NAME_NORMALIZED 0x0
#define PROCESS_QUERY_LIMITED_INFORMATION (0x1000)

#define NO_HAVE_MEMPCPY

#endif
