/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.util.Stack;
import org.treebind.DefaultFilterImplementation;
import org.treebind.Filter;
import org.treebind.JavaClassName;
import org.treebind.JavaMethodName;
import org.treebind.Name;
import org.treebind.Names;
import org.treebind.Pipe;
import org.treebind.RdfResourceName;
import org.treebind.Util;

public class JenaRdf2JavaObjectFilter
extends DefaultFilterImplementation
implements Filter {
    private Stack stack = null;

    public JenaRdf2JavaObjectFilter(Pipe pipe) {
        super(pipe);
    }

    public void addLeaf(Name role, Name nature, Object value) throws Exception {
        block5: {
            Context previous = this.getPrevious();
            if (!previous.isIgnored()) {
                try {
                    if (previous.isContainer()) {
                        super.addLeaf(previous.role, nature, value);
                    } else {
                        super.addLeaf(role, nature, value);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (RdfResourceName.URI.equals(role)) break block5;
                    throw nsme;
                }
            }
        }
    }

    public Name convertGenericNature(Name role, Name nature) {
        String genericName = (String)this.pipe.getParameter("namespace2class", nature.getDomainName());
        return new JavaClassName(genericName);
    }

    public Name convertNature(Name role, Name nature) {
        if (Names.literal.equals(nature)) {
            return new JavaClassName("java.lang.String");
        }
        String localName = nature.getLocalName();
        localName = Util.ToUpperCamelCase(localName);
        String domainName = (String)this.pipe.getParameter("namespace2package", nature.getDomainName());
        return new JavaClassName(domainName, localName);
    }

    public Name convertRole(Name role, Name nature) {
        String exactName = (String)this.pipe.getParameter("resource2method", role.getFullName());
        if (exactName != null) {
            return new JavaMethodName(exactName, false);
        }
        return new JavaMethodName(Util.ToUpperCamelCase(role.getLocalName()));
    }

    public void endProperty() throws Exception {
        Context current = (Context)this.stack.pop();
        if (!current.isContainer() && !current.isIgnored()) {
            super.endProperty();
        }
    }

    Context getPrevious() {
        if (this.stack == null) {
            this.stack = new Stack();
            return new Context();
        }
        return (Context)this.stack.peek();
    }

    boolean startOneOfTwoProperties(Name role, Name nature) throws Exception {
        try {
            try {
                this.sink.startProperty(this.convertRole(role, nature), this.convertNature(role, nature));
            }
            catch (ClassNotFoundException e) {
                this.sink.startProperty(this.convertRole(role, nature), this.convertGenericNature(role, nature));
            }
            return true;
        }
        catch (NoSuchMethodException nsme) {
            if (!RdfResourceName.type.equals(role)) {
                throw nsme;
            }
            return false;
        }
    }

    public void startProperty(Name role, Name nature) throws Exception {
        Context previous = this.getPrevious();
        Context context = new Context(role, nature);
        this.stack.push(context);
        if (previous.isIgnored()) {
            context.setIgnored(true);
        } else {
            boolean startOK = true;
            if (previous.isContainer()) {
                startOK = this.startOneOfTwoProperties(previous.role, nature);
            } else if (!context.isContainer()) {
                startOK = this.startOneOfTwoProperties(role, nature);
            }
            context.setIgnored(!startOK);
        }
    }

    class Context {
        boolean ignored;
        Name nature;
        Name role;

        public Context() {
            this.nature = null;
            this.role = null;
        }

        Context(Name role, Name nature) {
            this.role = role;
            this.nature = nature;
            this.ignored = false;
        }

        public Name getNature() {
            return this.nature;
        }

        public Name getRole() {
            return this.role;
        }

        public boolean isContainer() {
            if (this.nature == null) {
                return false;
            }
            if (RdfResourceName.seq.equals(this.nature)) {
                return true;
            }
            return RdfResourceName.bag.equals(this.nature);
        }

        public boolean isIgnored() {
            return this.ignored;
        }

        public void setIgnored(boolean ignored) {
            this.ignored = ignored;
        }
    }
}

