/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import org.treebind.DefaultFilterImplementation;
import org.treebind.Filter;
import org.treebind.LdapName;
import org.treebind.Name;
import org.treebind.Pipe;
import org.treebind.XmlElementName;

public class Ldap2XmlSaxFilter
extends DefaultFilterImplementation
implements Filter {
    public Ldap2XmlSaxFilter(Pipe pipe) {
        super(pipe);
    }

    public Name convertNature(Name role, Name nature) {
        if (LdapName.SEARCHRESULTS.equals(role)) {
            String ldapSearchResultsElement = (String)this.pipe.getParameterWithDefault("ldapSearchResultsElement", "ldapSearchResultsElement");
            return new XmlElementName(ldapSearchResultsElement);
        }
        if (LdapName.LDIF.equals(role)) {
            String ldapSearchResultsElement = (String)this.pipe.getParameterWithDefault("ldifElement", "ldifElement");
            return new XmlElementName(ldapSearchResultsElement);
        }
        if (LdapName.ENTRY.equals(role)) {
            String ldapEntry = (String)this.pipe.getParameterWithDefault("ldapEntry", "ldapEntry");
            return new XmlElementName(ldapEntry);
        }
        if (LdapName.LDIFRECORD.equals(role)) {
            String ldapEntry = (String)this.pipe.getParameterWithDefault("ldifRecord", "ldifRecord");
            return new XmlElementName(ldapEntry);
        }
        String defaultNamespace = (String)this.pipe.getParameterWithDefault("defaultLdapNamespace", "");
        if (LdapName.DN.equals(role)) {
            String ldapDN = (String)this.pipe.getParameterWithDefault("ldapDN", String.valueOf(defaultNamespace) + "ldapDN");
            return new XmlElementName(ldapDN);
        }
        return new XmlElementName(defaultNamespace, role.getLocalName());
    }
}

