/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.treebind.DefaultPipeElementImplementation;
import org.treebind.Name;
import org.treebind.Pipe;
import org.treebind.Sink;
import org.treebind.Source;
import org.treebind.XmlAttributeName;
import org.treebind.XmlElementName;
import org.treebind.XmlProductionName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlSaxSource
extends DefaultPipeElementImplementation
implements Source,
ContentHandler {
    Sink sink;
    Stack stack;

    public XmlSaxSource() {
    }

    public XmlSaxSource(Pipe pipe) {
        this.setPipe(pipe);
    }

    private void addLeaf(Name role, Name nature, String value) throws SAXException {
        try {
            this.sink.addLeaf(role, nature, value);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        Context context = (Context)this.stack.peek();
        context.appendCharacters(ch, start, length);
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Context context = (Context)this.stack.pop();
        if (context.mightBeLeaf()) {
            XmlElementName name = context.getElementName();
            this.addLeaf(name, name, context.getCharacters());
        } else {
            try {
                this.sendCharacters(context);
                this.sink.endProperty();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public Sink getSink() {
        return this.sink;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        SAXParser parser = new SAXParser();
        parser.setContentHandler(this);
        parser.parse(inputSource);
    }

    public void parse(Reader reader) throws Exception {
        this.parse(new InputSource(reader));
    }

    public void parse(String uri) throws Exception {
        this.parse(new InputSource(uri));
    }

    public void parseString(String xmlString) throws Exception {
        StringReader reader = new StringReader(xmlString);
        this.parse(reader);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    private void sendCharacters(Context context) throws SAXException {
        String textNode = context.getCharacters();
        context.resetCharacters();
        if (!"".equals(textNode) && !"".equals(textNode = textNode.trim())) {
            this.addLeaf(XmlProductionName.TEXTNODE, XmlProductionName.TEXTNODE, textNode);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.stack == null) {
            this.stack = new Stack();
        } else {
            Context previous = (Context)this.stack.peek();
            if (previous.mightBeLeaf) {
                previous.cantBeLeaf();
                this.startProperty(previous);
            }
            this.sendCharacters(previous);
        }
        Context context = new Context(new XmlElementName(namespaceURI, localName), atts.getLength() == 0);
        if (!context.mightBeLeaf) {
            this.startProperty(context);
            int i = 0;
            while (i < atts.getLength()) {
                XmlAttributeName name = new XmlAttributeName(atts.getURI(i), namespaceURI, atts.getLocalName(i));
                this.addLeaf(name, name, atts.getValue(i));
                ++i;
            }
        }
        this.stack.push(context);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void startProperty(Context context) throws SAXException {
        try {
            this.sink.startProperty(context.getElementName(), context.getElementName());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    class Context {
        StringBuffer characters;
        XmlElementName elementName;
        boolean mightBeLeaf;

        Context(XmlElementName elementName, boolean mightBeLeaf) {
            this.mightBeLeaf = mightBeLeaf;
            this.elementName = elementName;
            this.characters = new StringBuffer();
        }

        public void appendCharacters(char[] ch, int start, int length) {
            this.characters.append(ch, start, length);
        }

        public void cantBeLeaf() {
            this.mightBeLeaf = false;
        }

        public String getCharacters() {
            return this.characters.toString();
        }

        public XmlElementName getElementName() {
            return this.elementName;
        }

        public boolean mightBeLeaf() {
            return this.mightBeLeaf;
        }

        public void resetCharacters() {
            this.characters = new StringBuffer();
        }
    }
}

