/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.async;

import java.io.IOException;
import java.text.ChoiceFormat;
import java.util.Collection;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.NoSuchIndex;
import simtools.data.UnsupportedOperation;
import simtools.data.async.StreamingTSDataSource;
import simtools.data.async.StreamingTSDataSourceCollection;
import simtools.data.async.TimeStampedDataSource;
import simtools.data.async.TimeStampedDataSourceCollection;

public class StreamingMSDataSource
extends StreamingTSDataSource {
    private StreamingLabelSource _label;
    private StreamingIntegerSource _raw;
    private StreamingIntegerSource _status;
    protected transient String[] _l;
    protected transient long[] _r;
    protected transient long[] _s;

    public StreamingMSDataSource(String string, StreamingTSDataSourceCollection streamingTSDataSourceCollection, int n, double d, boolean bl, boolean bl2, boolean bl3) throws IOException, TimeStampedDataSourceCollection.InvalidFormatException {
        super(string, streamingTSDataSourceCollection, n, d);
        if (bl) {
            this._label = new StreamingLabelSource("label");
            this._l = new String[n];
        }
        if (bl2) {
            this._raw = new StreamingIntegerSource("raw");
            this._r = new long[n];
        }
        if (bl3) {
            this._status = new StreamingIntegerSource("status");
            this._s = new long[n];
        }
        this._auxiliaries = new AuxiliaryCollection();
    }

    public StreamingLabelSource getLabel() {
        return this._label;
    }

    public StreamingIntegerSource getRaw() {
        return this._raw;
    }

    public StreamingIntegerSource getStatus() {
        return this._status;
    }

    public void add(double d, double d2, String string, long l, long l2) {
        Object[] objectArray;
        this.add(d, d2);
        int n = this._lastIndex % this._size;
        if (this._l != null) {
            if (this._l.length != this._size) {
                objectArray = new String[this._size];
                System.arraycopy(this._l, 0, objectArray, 0, this._l.length);
                this._l = objectArray;
            }
            this._l[n] = string;
            this._label.notifyListenersForIndexRangeChange(this._startIndex, this._lastIndex);
            this._label.notifyEndNotificationListeners();
        }
        if (this._r != null) {
            if (this._r.length != this._size) {
                objectArray = new long[this._size];
                System.arraycopy(this._r, 0, objectArray, 0, this._r.length);
                this._r = (long[])objectArray;
            }
            this._r[n] = l;
            this._raw.notifyListenersForIndexRangeChange(this._startIndex, this._lastIndex);
            this._raw.notifyEndNotificationListeners();
        }
        if (this._s != null) {
            if (this._s.length != this._size) {
                objectArray = new long[this._size];
                System.arraycopy(this._s, 0, objectArray, 0, this._s.length);
                this._s = (long[])objectArray;
            }
            this._s[n] = l2;
            this._status.notifyListenersForIndexRangeChange(this._startIndex, this._lastIndex);
            this._status.notifyEndNotificationListeners();
        }
    }

    protected class AuxiliaryCollection
    extends TimeStampedDataSource.AuxiliaryCollection {
        protected AuxiliaryCollection() {
            super(StreamingMSDataSource.this);
        }

        public Object get(int n) {
            if (n == 0) {
                return super.get(n);
            }
            if (n == 1) {
                if (StreamingMSDataSource.this._label != null) {
                    return StreamingMSDataSource.this._label;
                }
                if (StreamingMSDataSource.this._raw != null) {
                    return StreamingMSDataSource.this._raw;
                }
                return StreamingMSDataSource.this._status;
            }
            if (n == 2) {
                if (StreamingMSDataSource.this._raw != null && StreamingMSDataSource.this._label != null) {
                    return StreamingMSDataSource.this._raw;
                }
                return StreamingMSDataSource.this._status;
            }
            if (n == 3) {
                return StreamingMSDataSource.this._status;
            }
            return null;
        }

        public int size() {
            return 1 + (StreamingMSDataSource.this._label == null ? 0 : 1) + (StreamingMSDataSource.this._raw == null ? 0 : 1) + (StreamingMSDataSource.this._status == null ? 0 : 1);
        }
    }

    public class StreamingIntegerSource
    extends StreamingTSDataSource {
        protected String type;

        public StreamingIntegerSource(String string) throws IOException, TimeStampedDataSourceCollection.InvalidFormatException {
            super(StreamingMSDataSource.this.getName(), (StreamingTSDataSourceCollection)StreamingMSDataSource.this.getCollection(), StreamingMSDataSource.this._size, StreamingMSDataSource.this._minDuration);
            this.setTime(StreamingMSDataSource.this.getTime());
            this.type = string;
        }

        public long getStartIndex() throws UnsupportedOperation {
            return StreamingMSDataSource.this._startIndex;
        }

        public long getLastIndex() throws UnsupportedOperation {
            return StreamingMSDataSource.this._lastIndex;
        }

        public Object getValue(long l) throws DataException {
            if (StreamingMSDataSource.this._startIndex < 0) {
                throw new NoSuchIndex(l);
            }
            if (l < (long)StreamingMSDataSource.this._startIndex) {
                throw new NoSuchIndex(l);
            }
            if (l > (long)StreamingMSDataSource.this._lastIndex) {
                throw new NoSuchIndex(l);
            }
            if (this.type.equals("raw")) {
                if (StreamingMSDataSource.this._r == null) {
                    throw new DataException();
                }
                return new Long(StreamingMSDataSource.this._r[(int)l % StreamingMSDataSource.this._size]);
            }
            if (this.type.equals("status")) {
                if (StreamingMSDataSource.this._s == null) {
                    throw new DataException();
                }
                return new Long(StreamingMSDataSource.this._s[(int)l % StreamingMSDataSource.this._size]);
            }
            throw new DataException();
        }

        public long getLongValue(long l) throws DataException {
            if (StreamingMSDataSource.this._startIndex < 0) {
                throw new NoSuchIndex(l);
            }
            if (l < (long)StreamingMSDataSource.this._startIndex) {
                throw new NoSuchIndex(l);
            }
            if (l > (long)StreamingMSDataSource.this._lastIndex) {
                throw new NoSuchIndex(l);
            }
            if (this.type.equals("raw")) {
                if (StreamingMSDataSource.this._r == null) {
                    throw new DataException();
                }
                return StreamingMSDataSource.this._r[(int)l % StreamingMSDataSource.this._size];
            }
            if (this.type.equals("status")) {
                if (StreamingMSDataSource.this._s == null) {
                    throw new DataException();
                }
                return StreamingMSDataSource.this._s[(int)l % StreamingMSDataSource.this._size];
            }
            throw new DataException();
        }

        public double getDoubleValue(long l) throws DataException {
            if (StreamingMSDataSource.this._startIndex < 0) {
                throw new NoSuchIndex(l);
            }
            if (l < (long)StreamingMSDataSource.this._startIndex) {
                throw new NoSuchIndex(l);
            }
            if (l > (long)StreamingMSDataSource.this._lastIndex) {
                throw new NoSuchIndex(l);
            }
            if (this.type.equals("raw")) {
                if (StreamingMSDataSource.this._r == null) {
                    throw new DataException();
                }
                return StreamingMSDataSource.this._r[(int)l % StreamingMSDataSource.this._size];
            }
            if (this.type.equals("status")) {
                if (StreamingMSDataSource.this._s == null) {
                    throw new DataException();
                }
                return StreamingMSDataSource.this._s[(int)l % StreamingMSDataSource.this._size];
            }
            throw new DataException();
        }

        public double getStart() {
            return 0.0;
        }

        public double getEnd() {
            return 0.0;
        }

        protected void computeMinMax() throws UnsupportedOperation {
        }

        public boolean isValid() {
            return false;
        }

        public ChoiceFormat getChoiceFormat() {
            return null;
        }

        public Collection getAuxiliarySources() {
            return null;
        }

        public boolean isCompound() {
            return false;
        }

        public DataInfo getInformation() {
            return new DataInfo(this.type, this.getName() + "." + this.type, "", "");
        }
    }

    public class StreamingLabelSource
    extends StreamingTSDataSource {
        protected String type;

        public StreamingLabelSource(String string) throws IOException, TimeStampedDataSourceCollection.InvalidFormatException {
            super(StreamingMSDataSource.this.getName(), (StreamingTSDataSourceCollection)StreamingMSDataSource.this.getCollection(), StreamingMSDataSource.this._size, StreamingMSDataSource.this._minDuration);
            this.setTime(StreamingMSDataSource.this.getTime());
            this.type = string;
        }

        public long getStartIndex() throws UnsupportedOperation {
            return StreamingMSDataSource.this._startIndex;
        }

        public long getLastIndex() throws UnsupportedOperation {
            return StreamingMSDataSource.this._lastIndex;
        }

        public Object getValue(long l) throws DataException {
            if (StreamingMSDataSource.this._startIndex < 0) {
                throw new NoSuchIndex(l);
            }
            if (l < (long)StreamingMSDataSource.this._startIndex) {
                throw new NoSuchIndex(l);
            }
            if (l > (long)StreamingMSDataSource.this._lastIndex) {
                throw new NoSuchIndex(l);
            }
            if (this.type.equals("label")) {
                if (StreamingMSDataSource.this._l == null) {
                    throw new DataException();
                }
                return StreamingMSDataSource.this._l[(int)l % StreamingMSDataSource.this._size];
            }
            throw new DataException();
        }

        public Collection getAuxiliarySources() {
            return null;
        }

        public boolean isCompound() {
            return false;
        }

        public DataInfo getInformation() {
            return new DataInfo(this.type, this.getName() + "." + this.type, "", "");
        }
    }
}

