/* $Id: MockSimpleConsumer.java,v 1.1 2005/04/09 03:35:04 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;


import tsp.core.common.url.TspURLException;
import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleConsumer;
import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;
import tsp.core.consumer.simple.TspSimpleSession;

public class MockSimpleConsumer implements TspSimpleConsumer {
	
	private TspSimpleSampleSymbolInfo[] infos;
	private MockSimpleSession session;
		
	public MockSimpleConsumer(TspSimpleSampleSymbolInfo[] infos) {
		this.infos = infos;
	}
	
	public TspSimpleSession openSession() throws TspURLException, TspConsumerException {
		try {
			session = new MockSimpleSession(infos);
			return session;
		} catch (Exception e) {
			throw (IllegalStateException)(new IllegalStateException()).initCause(e);
		}
	}
	
	

	/**
	 * @return Returns the session.
	 */
	public MockSimpleSession getSession() {
		return session;
	}
}
