/* $Id: NamespaceHelperTest.java,v 1.1 2005/04/09 03:35:04 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;

import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;
import junit.framework.TestCase;



public class NamespaceHelperTest extends TestCase {
	
	public void testGetNamespaceNominal() throws Exception{
		assertEquals("namespace", NamespaceHelper.getNamespace("namespace::blabla") );
	}
	
	public void testGetNamespaceNoNamespace() {
		
		try {
			NamespaceHelper.getNamespace("blabla");
			fail("An exception was expected");
		} catch (TspConsumerException e) {
			assertEquals("tsp.core.consumer.TspConsumerException: No namespace for string : blabla", e.toString());
		}
		
	}
	
	public void testGetNamespaceBegin() throws Exception{
		try {
			NamespaceHelper.getNamespace("::blabla");
			fail("An exception was expected");
		} catch (TspConsumerException e) {
			assertEquals("tsp.core.consumer.TspConsumerException: Empty namespace forbiden. String was : ::blabla", e.toString());
		}
	}
	
	public void testGetNamespaceEmptyName() throws Exception{
		try {
			NamespaceHelper.getNamespace("namespace::");
			fail("An exception was expected");
		} catch (TspConsumerException e) {
			assertEquals("tsp.core.consumer.TspConsumerException: Empty name forbiden. String was : namespace::", e.toString());
		}
	}
	
	public void testGetOnlyName() throws Exception{		
		assertEquals("blabla", NamespaceHelper.getOnlyName("namespace::blabla") );
	}
	
	public void testAddNamespace() throws Exception{		
			assertEquals("namespace::name", NamespaceHelper.addNamespace("namespace", "name"));
	}
	
	
	public void testRemoveNamespaceFromInfo() throws Exception{
		TspSimpleSampleSymbolInfo info = new TspSimpleSampleSymbolInfo("toto::tutu::titi", 10, 20, 30);
		TspSimpleSampleSymbolInfo infoNoNS = NamespaceHelper.removeNamespace(info);
		assertEquals("tutu::titi", infoNoNS.getName());
		assertEquals(10, infoNoNS.getPeriod());
		assertEquals(20, infoNoNS.getPhase());
		assertEquals(30, infoNoNS.getIndex());
	}
	
	public void testAddNamespaceToInfo() throws Exception{
		TspSimpleSampleSymbolInfo info = new TspSimpleSampleSymbolInfo("tutu::titi", 10, 20, 30);
		TspSimpleSampleSymbolInfo infoWithNS = NamespaceHelper.addNamespace("toto",info);
		assertEquals("toto::tutu::titi", infoWithNS.getName());
		assertEquals(10, infoWithNS.getPeriod());
		assertEquals(20, infoWithNS.getPhase());
		assertEquals(30, infoWithNS.getIndex());
	}

}
